/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.projectile.mob;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.boss.CorallusEntity;
import net.tslat.aoa3.util.WorldUtil;

public class CorallusShotEntity
extends FlyingEntity {
    private final CorallusEntity corallus;
    private final LivingEntity target;
    private final float dmg;

    public CorallusShotEntity(CorallusEntity corallus, LivingEntity target, int dmg) {
        super((EntityType)AoAEntities.Projectiles.CORALLUS_SHOT.get(), corallus.field_70170_p);
        this.corallus = corallus;
        this.target = target;
        this.dmg = dmg;
        this.func_189654_d(true);
    }

    public CorallusShotEntity(EntityType<? extends FlyingEntity> entityType, World world) {
        super(entityType, world);
        this.corallus = null;
        this.target = null;
        this.dmg = 0.0f;
    }

    public boolean func_180427_aV() {
        return true;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new CorallusShotTargetGoal(this));
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_145773_az() {
        return true;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ITEM_CORAL_STAFF_CAST.get();
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return null;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return null;
    }

    public boolean func_189652_ae() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
        return true;
    }

    protected void func_82167_n(Entity entityIn) {
        if (!this.field_70170_p.field_72995_K && entityIn == this.target) {
            this.target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), this.dmg);
            WorldUtil.createExplosion((Entity)this.corallus, this.field_70170_p, (Entity)this, 1.0f);
            this.func_70106_y();
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    private class CorallusShotTargetGoal
    extends Goal {
        private final CorallusShotEntity shot;

        public CorallusShotTargetGoal(CorallusShotEntity shot) {
            this.shot = shot;
        }

        public boolean func_220685_C_() {
            return false;
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75249_e() {
            if (!(CorallusShotEntity.this.field_70170_p.field_72995_K || this.shot.target != null && this.shot.target.func_70089_S())) {
                CorallusShotEntity.this.func_70106_y();
            }
        }

        public boolean func_75253_b() {
            return true;
        }

        public void func_75246_d() {
            if (this.shot.target == null || !this.shot.target.func_70089_S()) {
                if (!CorallusShotEntity.this.field_70170_p.field_72995_K) {
                    WorldUtil.createExplosion((Entity)CorallusShotEntity.this.corallus, CorallusShotEntity.this.field_70170_p, (Entity)this.shot, 1.0f);
                    CorallusShotEntity.this.func_70106_y();
                }
            } else {
                double distanceX = this.shot.target.func_226277_ct_() - this.shot.func_226277_ct_();
                double distanceY = this.shot.target.func_226278_cu_() - this.shot.func_226278_cu_();
                double distanceZ = this.shot.target.func_226281_cx_() - this.shot.func_226281_cx_();
                if (Math.signum(distanceX) != 0.0 || Math.signum(distanceY) != 0.0 || Math.signum(distanceZ) != 0.0) {
                    Vec3d motion = this.shot.func_213322_ci();
                    this.shot.func_213317_d(motion.func_72441_c((Math.signum(distanceX) * 0.3 - motion.func_82615_a()) * (double)0.1f, (Math.signum(distanceY) * 0.3 - motion.func_82617_b()) * (double)0.1f, (Math.signum(distanceZ) * 0.3 - motion.func_82616_c()) * (double)0.1f));
                    this.shot.field_70177_z += MathHelper.func_76142_g((float)((float)(Math.atan2(this.shot.func_213322_ci().func_82616_c(), this.shot.func_213322_ci().func_82615_a()) * 180.0 / Math.PI) - 90.0f - this.shot.field_70177_z));
                }
            }
        }
    }
}

