/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.projectile.staff;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.network.IPacket;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;
import net.tslat.aoa3.item.EnergyProjectileWeapon;

public abstract class BaseEnergyShot
extends ThrowableEntity {
    protected int lifespan;
    private int age = 0;
    protected EnergyProjectileWeapon weapon;

    public BaseEnergyShot(EntityType<? extends ThrowableEntity> entityType, World world) {
        super(entityType, world);
    }

    public BaseEnergyShot(EntityType<? extends ThrowableEntity> entityType, LivingEntity shooter, EnergyProjectileWeapon weapon, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        super(entityType, shooter.field_70170_p);
        this.lifespan = 60;
        this.weapon = weapon;
        this.field_70192_c = shooter;
        this.field_184539_c = shooter;
        this.func_70012_b(posX, posY, posZ, 0.0f, 360.0f);
        this.func_213317_d(new Vec3d(motionX, motionY, motionZ));
    }

    public BaseEnergyShot(EntityType<? extends ThrowableEntity> entityType, LivingEntity shooter, EnergyProjectileWeapon weapon, double posX, double posY, double posZ, float velocity) {
        super(entityType, shooter.field_70170_p);
        this.lifespan = 120;
        this.weapon = weapon;
        this.field_70192_c = shooter;
        this.field_184539_c = shooter;
        this.func_70012_b(posX, posY, posZ, 0.0f, 360.0f);
        this.func_213317_d(new Vec3d(this.field_70146_Z.nextGaussian() / 33.0 + 0.03, (double)(-velocity), this.field_70146_Z.nextGaussian() / 33.0 + 0.03));
    }

    public BaseEnergyShot(EntityType<? extends ThrowableEntity> entityType, LivingEntity shooter, EnergyProjectileWeapon weapon, int maxAge, float xMod, float yMod, float zMod) {
        super(entityType, shooter.field_70170_p);
        this.lifespan = maxAge;
        this.weapon = weapon;
        this.field_70192_c = shooter;
        this.field_184539_c = shooter;
        this.func_70012_b(shooter.func_226277_ct_(), shooter.func_226278_cu_() + (double)shooter.func_70047_e(), shooter.func_226281_cx_(), shooter.field_70177_z, shooter.field_70125_A);
        boolean right = true;
        if (shooter instanceof PlayerEntity) {
            if (weapon.getWeaponHand(shooter) == Hand.MAIN_HAND) {
                if (shooter.func_184591_cq() == HandSide.LEFT) {
                    right = false;
                }
            } else if (shooter.func_184591_cq() == HandSide.RIGHT) {
                right = false;
            }
        }
        this.func_70186_c((double)(-MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI))) + (double)xMod, (double)(-MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI))) + (double)yMod, (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI))) + (double)zMod, 3.0f, 1.0f);
        if (right) {
            this.func_70107_b(this.func_213322_ci().func_82615_a() * 0.5 + this.func_226277_ct_() - (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.4f), this.func_213322_ci().func_82617_b() * 0.5 + this.func_226278_cu_() - 0.3, this.func_213322_ci().func_82616_c() * 0.5 + this.func_226281_cx_() + (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.4f));
        } else {
            this.func_70107_b(this.func_213322_ci().func_82615_a() * 0.5 + this.func_226277_ct_() + (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.4f), this.func_213322_ci().func_82617_b() * 0.5 + this.func_226278_cu_() - 0.3, this.func_213322_ci().func_82616_c() * 0.5 + this.func_226281_cx_() - (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.4f));
        }
    }

    public BaseEnergyShot(EntityType<? extends ThrowableEntity> entityType, LivingEntity shooter, EnergyProjectileWeapon weapon, int maxAge) {
        super(entityType, shooter.field_70170_p);
        boolean right;
        this.lifespan = maxAge;
        this.weapon = weapon;
        this.field_70192_c = shooter;
        this.field_184539_c = shooter;
        this.func_70012_b(shooter.func_226277_ct_(), shooter.func_226278_cu_() + (double)shooter.func_70047_e(), shooter.func_226281_cx_(), shooter.field_70177_z, shooter.field_70125_A);
        boolean bl = right = shooter.func_184591_cq() == HandSide.RIGHT;
        if (shooter instanceof PlayerEntity) {
            if (weapon.getWeaponHand(shooter) == Hand.MAIN_HAND) {
                if (shooter.func_184591_cq() == HandSide.LEFT) {
                    right = false;
                }
            } else if (shooter.func_184591_cq() == HandSide.RIGHT) {
                right = false;
            }
        }
        this.func_70186_c(-MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)), -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI)), MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)), 3.0f, 1.0f);
        if (right) {
            this.func_70107_b(this.func_213322_ci().func_82615_a() * 0.5 + this.func_226277_ct_() - (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.4f), this.func_213322_ci().func_82617_b() * 0.5 + this.func_226278_cu_() - 0.3, this.func_213322_ci().func_82616_c() * 0.5 + this.func_226281_cx_() + (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.4f));
        } else {
            this.func_70107_b(this.func_213322_ci().func_82615_a() * 0.5 + this.func_226277_ct_() + (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.4f), this.func_213322_ci().func_82617_b() * 0.5 + this.func_226278_cu_() - 0.3, this.func_213322_ci().func_82616_c() * 0.5 + this.func_226281_cx_() - (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.4f));
        }
    }

    public BaseEnergyShot(EntityType<? extends ThrowableEntity> entityType, World world, double x, double y, double z) {
        super(entityType, world);
    }

    protected void func_70184_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.weapon != null && this.func_70089_S()) {
                if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
                    this.weapon.doBlockImpact(this, result.func_216347_e(), this.field_70192_c);
                } else if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
                    this.weapon.doEntityImpact(this, ((EntityRayTraceResult)result).func_216348_a(), this.field_70192_c);
                }
            }
            this.func_70106_y();
        }
    }

    protected void func_70088_a() {
    }

    public boolean func_180427_aV() {
        return true;
    }

    public void func_70071_h_() {
        Vec3d velocityAdjustedPosition;
        Vec3d position;
        if (!this.func_70089_S()) {
            return;
        }
        Vec3d motion = this.func_213322_ci();
        BlockRayTraceResult raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(position = new Vec3d(this.func_226277_ct_() - motion.func_82615_a() * 0.5, this.func_226278_cu_() - motion.func_82617_b() * 0.5, this.func_226281_cx_() - motion.func_82616_c() * 0.5), velocityAdjustedPosition = new Vec3d(this.func_226277_ct_() + motion.func_82615_a(), this.func_226278_cu_() + motion.func_82617_b(), this.func_226281_cx_() + motion.func_82616_c()), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.ANY, null));
        velocityAdjustedPosition = raytraceresult.func_216346_c() != RayTraceResult.Type.MISS ? new Vec3d(raytraceresult.func_216347_e().field_72450_a, raytraceresult.func_216347_e().field_72448_b, raytraceresult.func_216347_e().field_72449_c) : new Vec3d(this.func_226277_ct_() + motion.func_82615_a(), this.func_226278_cu_() + motion.func_82617_b(), this.func_226281_cx_() + motion.func_82616_c());
        EntityRayTraceResult entityTrace = ProjectileHelper.func_221271_a((World)this.field_70170_p, (Entity)this, (Vec3d)position, (Vec3d)velocityAdjustedPosition, (AxisAlignedBB)this.func_174813_aQ().func_72321_a(motion.func_82615_a(), motion.func_82617_b(), motion.func_82616_c()).func_186662_g(0.5), entity -> entity.func_70089_S() && entity.func_70067_L() && !entity.func_175149_v() && entity != this.field_184539_c);
        if (entityTrace != null) {
            raytraceresult = entityTrace;
        }
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((ThrowableEntity)this, (RayTraceResult)raytraceresult)) {
            this.func_70184_a((RayTraceResult)raytraceresult);
        }
        this.field_70142_S = this.func_226277_ct_();
        this.field_70137_T = this.func_226278_cu_();
        this.field_70136_U = this.func_226281_cx_();
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_174854_a || this.age > this.lifespan) {
                this.func_70106_y();
            } else {
                ++this.age;
            }
        }
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public int getAge() {
        return this.age;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

