/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.projectile.thrown;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.AoAWeapons;
import net.tslat.aoa3.entity.projectile.HardProjectile;
import net.tslat.aoa3.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.PotionUtil;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class GooBallEntity
extends BaseBullet
implements HardProjectile,
IRendersAsItem {
    public GooBallEntity(EntityType<? extends ThrowableEntity> entityType, World world) {
        super(entityType, world);
    }

    public GooBallEntity(World world) {
        super((EntityType<? extends ThrowableEntity>)((EntityType)AoAEntities.Projectiles.GOO_BALL.get()), world);
    }

    public GooBallEntity(LivingEntity shooter, BaseGun gun) {
        super((EntityType<? extends ThrowableEntity>)((EntityType)AoAEntities.Projectiles.GOO_BALL.get()), shooter, gun, 1.0f, 0, 3.0f);
    }

    public GooBallEntity(LivingEntity shooter, BaseGun gun, Hand hand, int maxAge, int piercingValue) {
        super((EntityType<? extends ThrowableEntity>)((EntityType)AoAEntities.Projectiles.GOO_BALL.get()), shooter, gun, hand, maxAge, 1.0f, piercingValue);
    }

    public GooBallEntity(World world, double x, double y, double z) {
        super((EntityType<? extends ThrowableEntity>)((EntityType)AoAEntities.Projectiles.GOO_BALL.get()), world, x, y, z);
    }

    @Override
    public float func_70185_h() {
        return 0.05f;
    }

    @Override
    public void doEntityImpact(Entity target) {
        target.func_70097_a(DamageSource.func_76356_a((Entity)this, null), 3.5f);
        if (target instanceof LivingEntity) {
            EntityUtil.applyPotions(target, new PotionUtil.EffectBuilder(Effects.field_76421_d, 60).level(2));
        }
        this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)AoASounds.GOO_BALL_IMPACT.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    protected void func_70184_a(RayTraceResult result) {
        if (result instanceof BlockRayTraceResult && this.field_70173_aa <= 1 && this.func_85052_h() == null) {
            return;
        }
        super.func_70184_a(result);
    }

    public ItemStack func_184543_l() {
        return new ItemStack((IItemProvider)AoAWeapons.GOO_BALL.get());
    }
}

