/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.projectile.thrown;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.AoAWeapons;
import net.tslat.aoa3.entity.projectile.HardProjectile;
import net.tslat.aoa3.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.entity.projectile.misc.HellfireProjectileEntity;
import net.tslat.aoa3.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.EntityUtil;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class HellfireEntity
extends BaseBullet
implements HardProjectile,
IRendersAsItem {
    private float explosionStrength = 1.5f;
    private LivingEntity shooter;
    private BaseGun gun;

    public HellfireEntity(EntityType<? extends ThrowableEntity> entityType, World world) {
        super(entityType, world);
    }

    public HellfireEntity(World world) {
        super((EntityType<? extends ThrowableEntity>)((EntityType)AoAEntities.Projectiles.HELLFIRE.get()), world);
    }

    public HellfireEntity(LivingEntity shooter, BaseGun gun) {
        super((EntityType<? extends ThrowableEntity>)((EntityType)AoAEntities.Projectiles.HELLFIRE.get()), shooter, gun, 1.0f, 0, 1.5f);
        this.shooter = shooter;
        this.gun = gun;
    }

    public HellfireEntity(LivingEntity shooter, BaseGun gun, Hand hand, int maxAge, int piercingValue) {
        super((EntityType<? extends ThrowableEntity>)((EntityType)AoAEntities.Projectiles.HELLFIRE.get()), shooter, gun, hand, maxAge, 1.0f, piercingValue);
    }

    public HellfireEntity(World world, double x, double y, double z) {
        super((EntityType<? extends ThrowableEntity>)((EntityType)AoAEntities.Projectiles.HELLFIRE.get()), world, x, y, z);
    }

    @Override
    public float func_70185_h() {
        return 0.075f;
    }

    public void setExplosionStrength(float strength) {
        this.explosionStrength = strength;
    }

    @Override
    protected void func_70184_a(RayTraceResult result) {
        if (result instanceof BlockRayTraceResult && this.field_70173_aa <= 1 && this.func_85052_h() == null) {
            return;
        }
        super.func_70184_a(result);
    }

    @Override
    public void doImpactEffect() {
        int count = 0;
        for (LivingEntity e : this.field_70170_p.func_175647_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(7.0), EntityUtil.Predicates.HOSTILE_MOB)) {
            this.field_70170_p.func_217376_c((Entity)new HellfireProjectileEntity(this, e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_()));
            e.func_70015_d(10);
            ++count;
        }
        if (this.shooter instanceof PlayerEntity) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)AoASounds.HELLFIRE_IMPACT.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
            if (count >= 20 && this.shooter instanceof ServerPlayerEntity) {
                AdvancementUtil.completeAdvancement((ServerPlayerEntity)this.shooter, new ResourceLocation("aoa3", "overworld/heckfire"), "20_target_hellfire");
            }
        }
    }

    public ItemStack func_184543_l() {
        return new ItemStack((IItemProvider)AoAWeapons.HELLFIRE.get());
    }
}

