/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.projectile.thrown;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.common.registration.AoAWeapons;
import net.tslat.aoa3.entity.mob.mysterium.RunicGolemEntity;
import net.tslat.aoa3.entity.projectile.HardProjectile;
import net.tslat.aoa3.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.PotionUtil;
import net.tslat.aoa3.util.WorldUtil;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class RunicBombEntity
extends BaseBullet
implements HardProjectile,
IRendersAsItem {
    private float explosionStrength = 1.5f;
    private LivingEntity shooter;

    public RunicBombEntity(EntityType<? extends ThrowableEntity> entityType, World world) {
        super(entityType, world);
    }

    public RunicBombEntity(World world) {
        super((EntityType<? extends ThrowableEntity>)((EntityType)AoAEntities.Projectiles.RUNIC_BOMB.get()), world);
    }

    public RunicBombEntity(LivingEntity shooter, BaseGun gun) {
        super((EntityType<? extends ThrowableEntity>)((EntityType)AoAEntities.Projectiles.RUNIC_BOMB.get()), shooter, gun, 1.0f, 0, 1.5f);
        this.shooter = shooter;
    }

    public RunicBombEntity(LivingEntity shooter, BaseGun gun, Hand hand, int maxAge, int piercingValue) {
        super((EntityType<? extends ThrowableEntity>)((EntityType)AoAEntities.Projectiles.RUNIC_BOMB.get()), shooter, gun, hand, maxAge, 1.0f, piercingValue);
    }

    public RunicBombEntity(World world, double x, double y, double z) {
        super((EntityType<? extends ThrowableEntity>)((EntityType)AoAEntities.Projectiles.RUNIC_BOMB.get()), world, x, y, z);
    }

    @Override
    public float func_70185_h() {
        return 0.1f;
    }

    public void setExplosionStrength(float strength) {
        this.explosionStrength = strength;
    }

    @Override
    protected void func_70184_a(RayTraceResult result) {
        if (result instanceof BlockRayTraceResult && this.field_70173_aa <= 1 && this.func_85052_h() == null) {
            return;
        }
        super.func_70184_a(result);
    }

    @Override
    public void doImpactEffect() {
        this.explode();
    }

    @Override
    public void doEntityImpact(Entity target) {
        this.explode();
    }

    private void explode() {
        WorldUtil.createExplosion((Entity)this.shooter, this.field_70170_p, (Entity)this, this.explosionStrength);
        for (LivingEntity e : this.field_70170_p.func_175647_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(3.0), EntityUtil.Predicates.HOSTILE_MOB)) {
            EntityUtil.applyPotions((Entity)e, new PotionUtil.EffectBuilder(Effects.field_76421_d, 30).level(100));
            if (!(e instanceof RunicGolemEntity) || !((RunicGolemEntity)e).isShielded()) continue;
            ((RunicGolemEntity)e).deactivateShield();
        }
    }

    public ItemStack func_184543_l() {
        return new ItemStack((IItemProvider)AoAWeapons.RUNIC_BOMB.get());
    }
}

