/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.tablet;

import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.item.tablet.TabletItem;
import net.tslat.aoa3.util.constant.Resources;
import net.tslat.aoa3.util.player.PlayerUtil;
import org.apache.logging.log4j.Level;

public abstract class SoulTabletEntity
extends Entity {
    private static final DataParameter<Boolean> ACTIVE = EntityDataManager.func_187226_a(SoulTabletEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected ServerPlayerEntity owner = null;
    private UUID ownerUUID = null;

    public SoulTabletEntity(EntityType<? extends SoulTabletEntity> entityType, World world) {
        super(entityType, world);
        this.field_70156_m = true;
    }

    public SoulTabletEntity(EntityType<? extends SoulTabletEntity> entityType, World world, ServerPlayerEntity placer) {
        this(entityType, world);
        this.owner = placer;
        this.ownerUUID = this.owner != null ? this.owner.func_110124_au() : null;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ACTIVE, (Object)true);
    }

    public boolean func_184230_a(PlayerEntity player, Hand hand) {
        return this.ownerUUID == null || player.func_110124_au().equals(this.ownerUUID);
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vec3d vec, Hand hand) {
        if (this.func_70089_S() && (this.ownerUUID == null || player.func_110124_au().equals(this.ownerUUID))) {
            if (!this.field_70170_p.field_72995_K && !player.func_184812_l_()) {
                ItemStack stack = new ItemStack((IItemProvider)this.getRelevantItem());
                if (player.func_184586_b(hand).func_190926_b()) {
                    player.func_184611_a(hand, new ItemStack((IItemProvider)this.getRelevantItem()));
                } else if (!player.func_191521_c(stack)) {
                    this.func_70099_a(stack, 0.0f);
                }
            }
            this.func_70106_y();
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    protected void func_213281_b(CompoundNBT compound) {
        if (this.owner != null) {
            compound.func_74778_a("OwnedBy", this.ownerUUID.toString());
        }
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_74764_b("OwnedBy")) {
            try {
                this.ownerUUID = UUID.fromString(compound.func_74779_i("OwnedBy"));
                this.owner = this.field_70170_p instanceof ServerWorld ? (ServerPlayerEntity)this.field_70170_p.func_217371_b(this.ownerUUID) : null;
            }
            catch (IllegalArgumentException e) {
                Logging.logMessage(Level.WARN, "Unknown or malformed owner UUID for soul tablet entity: " + compound.func_74779_i("OwnerBy"));
            }
        }
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70089_S() && this.field_70173_aa % 5 == 0) {
                if (this.field_70170_p.func_175623_d(this.func_180425_c().func_177977_b())) {
                    ItemEntity itemDrop = this.func_70099_a(new ItemStack((IItemProvider)this.getRelevantItem()), 0.0f);
                    if (this.owner != null && itemDrop != null) {
                        itemDrop.func_200217_b(this.ownerUUID);
                    }
                    this.func_70106_y();
                    return;
                }
                if (this.isActive()) {
                    if (this.testSoulSupply()) {
                        this.doTickEffect();
                    } else {
                        this.deactivate();
                    }
                }
            }
        } else if (this.field_70170_p.func_175623_d(this.func_180425_c().func_177977_b())) {
            this.func_70106_y();
        }
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_180431_b(DamageSource source) {
        return source != DamageSource.field_76380_i;
    }

    public void func_213315_a(MoverType typeIn, Vec3d pos) {
    }

    protected abstract void doTickEffect();

    public abstract TabletItem getRelevantItem();

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private boolean testSoulSupply() {
        if (this.owner == null) {
            return false;
        }
        return PlayerUtil.consumeResource(this.owner, Resources.SOUL, this.getRelevantItem().getSoulDrain() * 5.0f * (PlayerUtil.isWearingFullSet(this.owner, AdventArmour.Type.ANIMA) ? 0.5f : 1.0f), false);
    }

    public boolean isActive() {
        return (Boolean)this.field_70180_af.func_187225_a(ACTIVE);
    }

    private void deactivate() {
        this.field_70180_af.func_187227_b(ACTIVE, (Object)false);
    }

    protected <T extends Entity> List<T> getTargetsWithinRadius(Class<? extends T> targetClass, @Nullable Predicate<? super T> predicate) {
        return this.field_70170_p.func_175647_a(targetClass, this.func_174813_aQ().func_186662_g((double)this.getRelevantItem().getEffectRadius()), predicate);
    }
}

