/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.event;

import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tslat.aoa3.command.StructureCommand;
import net.tslat.aoa3.common.registration.AoADimensions;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.entity.misc.HeartStoneEntity;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.library.misc.CustomisableParticleType;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.constant.Skills;
import net.tslat.aoa3.util.player.PlayerUtil;
import net.tslat.aoa3.util.skill.HunterUtil;
import net.tslat.aoa3.util.skill.InnervationUtil;

@Mod.EventBusSubscriber(modid="aoa3")
public class EntityEvents {
    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent ev) {
        Entity killer;
        LivingEntity entity = ev.getEntityLiving();
        if (!entity.field_70170_p.field_72995_K && !(entity instanceof PlayerEntity) && (killer = ev.getSource().func_76346_g()) != null) {
            PlayerEntity killerPlayer = null;
            if (killer instanceof TameableEntity) {
                LivingEntity owner = ((TameableEntity)killer).func_70902_q();
                if (owner instanceof PlayerEntity) {
                    killerPlayer = (PlayerEntity)owner;
                }
            } else if (killer instanceof PlayerEntity) {
                killerPlayer = (PlayerEntity)killer;
            }
            if (killerPlayer instanceof ServerPlayerEntity) {
                float hunterXp;
                if (entity.func_110138_aP() > 1.0f && RandomUtil.oneInNChance(EntityUtil.isHostileMob((Entity)entity) ? 8 : 24) && InnervationUtil.canEntitySpawnHeartstone((Entity)entity)) {
                    HeartStoneEntity heartStone = new HeartStoneEntity(entity.field_70170_p, entity.func_180425_c());
                    entity.field_70170_p.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), (SoundEvent)AoASounds.HEART_STONE_SPAWN.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                    entity.field_70170_p.func_217376_c((Entity)heartStone);
                }
                if (entity.field_70170_p.func_201675_m().func_186058_p() == DimensionType.field_223228_b_ && ev.getSource().field_76373_n.contains("explosion") && RandomUtil.oneInNChance(4)) {
                    entity.func_70099_a(new ItemStack((IItemProvider)AoAItems.EXPLOSIVE_IDOL.get()), 0.0f);
                }
                if ((hunterXp = HunterUtil.getHunterXp(entity)) > 0.0f) {
                    PlayerUtil.giveXpToPlayer((ServerPlayerEntity)killerPlayer, Skills.HUNTER, hunterXp);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityUpdate(LivingEvent.LivingUpdateEvent ev) {
        if (ev.getEntityLiving().field_70170_p.field_72995_K && ((Boolean)AoAConfig.CLIENT.partyDeaths.get()).booleanValue() && ev.getEntityLiving().field_70725_aQ >= 19) {
            AxisAlignedBB boundingBox = ev.getEntity().func_174813_aQ();
            double width = boundingBox.field_72336_d - boundingBox.field_72340_a;
            double depth = boundingBox.field_72334_f - boundingBox.field_72339_c;
            double height = boundingBox.field_72337_e - boundingBox.field_72338_b;
            int i = 0;
            while ((double)i < 3.0 + 10.0 * width * depth * height) {
                ev.getEntityLiving().field_70170_p.func_195594_a((IParticleData)new CustomisableParticleType.Data((ParticleType<CustomisableParticleType.Data>)((ParticleType)AoAParticleTypes.RAINBOW_SPARKLER.get()), 0.03f, 3.0f, 0), boundingBox.field_72340_a + RandomUtil.randomValueUpTo(width), boundingBox.field_72338_b + RandomUtil.randomValueUpTo(height), boundingBox.field_72339_c + RandomUtil.randomValueUpTo(depth), RandomUtil.randomScaledGaussianValue(0.05), 0.0, RandomUtil.randomScaledGaussianValue(0.05));
                ++i;
            }
        }
    }

    @SubscribeEvent
    public static void onEntityExploded(ExplosionEvent.Detonate ev) {
        if (((Boolean)AoAConfig.SERVER.saveLootFromExplosions.get()).booleanValue()) {
            ev.getAffectedEntities().removeIf(entity -> entity instanceof ItemEntity && entity.field_70173_aa < 20);
        }
    }

    @SubscribeEvent
    public static void onSpawnerSpawn(LivingSpawnEvent.SpecialSpawn ev) {
        if (ev.getSpawner() != null && HunterUtil.isHunterCreature(ev.getEntityLiving())) {
            ev.getEntityLiving().getPersistentData().func_74757_a("IsHunterSpawnerMob", true);
        }
    }

    @SubscribeEvent
    public static void onLivingTarget(LivingSetAttackTargetEvent ev) {
        PlayerEntity pl;
        int hunterLvl;
        if (!ev.getEntityLiving().field_70170_p.field_72995_K && ev.getEntityLiving() instanceof MobEntity && (ev.getTarget() instanceof PlayerEntity || ev.getTarget() instanceof TameableEntity) && (hunterLvl = HunterUtil.getHunterLevel(ev.getEntityLiving())) > 1 && !ev.getEntityLiving().getPersistentData().func_74767_n("IsHunterSpawnerMob") && (pl = PlayerUtil.getPlayerOrOwnerIfApplicable((Entity)ev.getTarget())) instanceof ServerPlayerEntity && !PlayerUtil.doesPlayerHaveLevel((ServerPlayerEntity)pl, Skills.HUNTER, hunterLvl)) {
            ((MobEntity)ev.getEntityLiving()).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public static void onEntityAttacked(LivingAttackEvent ev) {
        if (!HunterUtil.canAttackTarget(ev.getEntityLiving(), ev.getSource().func_76346_g(), true)) {
            ev.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent ev) {
        block4: {
            block5: {
                if (ev.getWorld().field_72995_K) break block4;
                if (StructureCommand.isConverting) {
                    StructureCommand.conversionEntityConsumer.accept(ev.getEntity());
                    ev.setCanceled(true);
                    return;
                }
                if (!(ev.getEntity() instanceof FishingBobberEntity)) break block5;
                FishingBobberEntity hook = (FishingBobberEntity)ev.getEntity();
                ServerPlayerEntity fisher = (ServerPlayerEntity)hook.func_190619_l();
                if (fisher == null || !PlayerUtil.isWearingFullSet(fisher, AdventArmour.Type.HAULING)) break block4;
                ItemStack stack = fisher.func_184586_b(Hand.MAIN_HAND);
                if (!(stack.func_77973_b() instanceof FishingRodItem)) {
                    stack = fisher.func_184586_b(Hand.OFF_HAND);
                }
                if (!(stack.func_77973_b() instanceof FishingRodItem)) break block4;
                hook.field_191519_ax = Math.min(5, 2 + EnchantmentHelper.func_191528_c((ItemStack)stack));
                break block4;
            }
            if (ev.getEntity() instanceof WitherEntity && ((WitherEntity)ev.getEntity()).func_82212_n() == 220 && ev.getWorld().func_201675_m().func_186058_p() == DimensionType.field_223228_b_) {
                for (PlayerEntity pl : ev.getWorld().func_217357_a(PlayerEntity.class, ev.getEntity().func_174813_aQ().func_186662_g(50.0))) {
                    if (!ItemUtil.findInventoryItem(pl, new ItemStack((IItemProvider)AoAItems.BLANK_REALMSTONE.get()), true, 1)) continue;
                    ItemUtil.givePlayerItemOrDrop(pl, new ItemStack((IItemProvider)AoAItems.ABYSS_REALMSTONE.get()));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLootDrops(LivingDropsEvent ev) {
        if (!ev.getEntityLiving().field_70170_p.field_72995_K) {
            if (ev.getEntityLiving().field_70170_p.func_201675_m().func_186058_p() == AoADimensions.ANCIENT_CAVERN.type() && ev.getEntityLiving().func_184222_aU()) {
                ev.getDrops().clear();
                ev.setCanceled(true);
                return;
            }
            if (!(!HunterUtil.isHunterCreature(ev.getEntityLiving()) || ev.isRecentlyHit() && ev.getSource().func_76346_g() instanceof PlayerEntity && HunterUtil.canAttackTarget(ev.getEntityLiving(), ev.getSource().func_76346_g(), false))) {
                ev.getDrops().clear();
                ev.setCanceled(true);
            }
        }
    }
}

