/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.event;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.item.Item;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tslat.aoa3.library.scheduling.AoAScheduler;

@Mod.EventBusSubscriber(modid="aoa3", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GlobalEvents {
    private static final HashMap<Item, Integer> FURNACE_FUELS = new HashMap();
    private static final HashMap<Supplier<? extends IItemProvider>, Integer> registeredFurnaceFuels = new HashMap();
    public static int tick;

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase == TickEvent.Phase.END) {
            ++tick;
        }
        AoAScheduler.handleSyncScheduledTasks(tick);
    }

    @SubscribeEvent
    public static void getBurnTime(FurnaceFuelBurnTimeEvent ev) {
        ev.setBurnTime(FURNACE_FUELS.getOrDefault(ev.getItemStack().func_77973_b(), ev.getBurnTime()).intValue());
    }

    public static void init() {
        for (Map.Entry<Supplier<? extends IItemProvider>, Integer> entry : registeredFurnaceFuels.entrySet()) {
            FURNACE_FUELS.put(entry.getKey().get().func_199767_j(), entry.getValue());
        }
    }

    public static void addFurnaceFuel(Supplier<? extends IItemProvider> item, int burnTime) {
        registeredFurnaceFuels.put(item, burnTime);
    }
}

