/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.event;

import java.util.List;
import java.util.UUID;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.block.Block;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.VineBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.ResourceDataPacket;
import net.tslat.aoa3.common.packet.packets.SkillDataPacket;
import net.tslat.aoa3.common.packet.packets.TributeDataPacket;
import net.tslat.aoa3.common.registration.AoADimensions;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.AoAWeapons;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.entity.misc.AnimaStoneEntity;
import net.tslat.aoa3.event.custom.events.PlayerLevelChangeEvent;
import net.tslat.aoa3.event.dimension.LelyetiaEvents;
import net.tslat.aoa3.event.dimension.OverworldEvents;
import net.tslat.aoa3.event.dimension.ShyrelandsEvents;
import net.tslat.aoa3.event.dimension.VoxPondsEvents;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.item.misc.BlankRealmstone;
import net.tslat.aoa3.item.misc.ReservedItem;
import net.tslat.aoa3.item.misc.summoning.BossSpawningItem;
import net.tslat.aoa3.item.tool.SpecialHarvestTool;
import net.tslat.aoa3.item.tool.misc.ExpFlask;
import net.tslat.aoa3.library.misc.AoAHalos;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.aoa3.util.constant.Deities;
import net.tslat.aoa3.util.constant.Resources;
import net.tslat.aoa3.util.constant.Skills;
import net.tslat.aoa3.util.player.PlayerDataManager;
import net.tslat.aoa3.util.player.PlayerUtil;
import net.tslat.aoa3.util.skill.ButcheryUtil;
import net.tslat.aoa3.util.skill.ExpeditionUtil;
import net.tslat.aoa3.util.skill.ForagingUtil;
import net.tslat.aoa3.util.skill.InnervationUtil;
import net.tslat.aoa3.util.skill.LoggingUtil;
import org.apache.logging.log4j.Level;

@Mod.EventBusSubscriber(modid="aoa3")
public class PlayerEvents {
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase == TickEvent.Phase.END) {
            if (ev.player instanceof ServerPlayerEntity) {
                PlayerUtil.getAdventPlayer((ServerPlayerEntity)ev.player).tickPlayer();
                if (!ev.player.func_184812_l_() && ev.player.field_70122_E && !ev.player.func_184207_aI() && ev.player.func_184187_bx() == null) {
                    ExpeditionUtil.handleRunningTick(ev, (ServerPlayerEntity)ev.player);
                }
            }
            if (ev.player.field_71093_bK == AoADimensions.SHYRELANDS.type()) {
                if (!ev.player.field_70170_p.field_72995_K) {
                    ShyrelandsEvents.doPlayerTick(ev.player);
                }
            } else if (ev.player.field_71093_bK == AoADimensions.LELYETIA.type()) {
                LelyetiaEvents.doPlayerTick(ev.player);
            } else if (ev.player.field_71093_bK == AoADimensions.VOX_PONDS.type() && !ev.player.field_70170_p.field_72995_K) {
                VoxPondsEvents.doPlayerTick(ev.player);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerHit(LivingAttackEvent ev) {
        if (ev.getEntityLiving() instanceof ServerPlayerEntity) {
            PlayerDataManager plData = PlayerUtil.getAdventPlayer((ServerPlayerEntity)ev.getEntityLiving());
            plData.handleIncomingAttack(ev);
            if (ev.getEntityLiving().func_110143_aJ() - ev.getAmount() <= 0.0f && ev.getEntityLiving().field_70170_p.func_72912_H().func_76093_s()) {
                ReservedItem.handlePlayerDeath((PlayerEntity)((ServerPlayerEntity)ev.getEntityLiving()));
            }
        }
    }

    @SubscribeEvent
    public static void onEnderPearl(EnderTeleportEvent ev) {
        if (!ev.getEntityLiving().field_70170_p.func_201670_d() && ev.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity pl = (PlayerEntity)ev.getEntityLiving();
            if (!pl.field_70170_p.func_201675_m().func_186058_p().isVanilla() && ev.getTargetY() >= (double)pl.field_70170_p.func_72940_L()) {
                ev.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLevelUp(PlayerLevelChangeEvent ev) {
        double healthBuff;
        if (ev.getSkill() == Skills.INNERVATION && (healthBuff = InnervationUtil.getHealthBuff(ev.getNewLevel())) != InnervationUtil.getHealthBuff(ev.getOldLevel())) {
            EntityUtil.removeAttributeModifier(ev.getEntityLiving(), SharedMonsterAttributes.field_111267_a, InnervationUtil.INNERVATION_HEALTH_BUFF);
            if (healthBuff > 0.0) {
                EntityUtil.applyAttributeModifierSafely(ev.getEntityLiving(), SharedMonsterAttributes.field_111267_a, InnervationUtil.getHealthModifier(ev.getNewLevel()));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerDamaged(LivingDamageEvent ev) {
        if (ev.getEntityLiving() instanceof ServerPlayerEntity) {
            PlayerDataManager plData = PlayerUtil.getAdventPlayer((ServerPlayerEntity)ev.getEntityLiving());
            if (ev.getEntityLiving().func_110143_aJ() > 0.0f) {
                plData.handleDamageTriggers(ev);
                if (ev.getSource().func_76346_g() instanceof LivingEntity && RandomUtil.oneInNChance(15)) {
                    plData.enableRevenge((LivingEntity)ev.getSource().func_76346_g());
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerHurt(LivingHurtEvent ev) {
        if (!ev.getEntityLiving().field_70170_p.field_72995_K) {
            if (ev.getEntityLiving() instanceof ServerPlayerEntity) {
                ServerPlayerEntity pl = (ServerPlayerEntity)ev.getEntityLiving();
                PlayerUtil.getAdventPlayer(pl).handleIncomingDamage(ev);
                Entity creeper = ev.getSource().func_76364_f();
                if (pl.func_110143_aJ() > 0.0f && ev.getSource().func_94541_c() && creeper instanceof CreeperEntity && (!pl.field_70170_p.func_217357_a(TNTEntity.class, creeper.func_174813_aQ().func_186662_g(3.0)).isEmpty() || !pl.field_70170_p.func_217357_a(TNTEntity.class, pl.func_174813_aQ().func_186662_g(3.0)).isEmpty()) && ItemUtil.findInventoryItem((PlayerEntity)pl, new ItemStack((IItemProvider)AoAItems.BLANK_REALMSTONE.get()), true, 1)) {
                    ItemUtil.givePlayerItemOrDrop((PlayerEntity)pl, new ItemStack((IItemProvider)AoAItems.CREEPONIA_REALMSTONE.get()));
                }
            } else if (ev.getSource().func_76346_g() instanceof ServerPlayerEntity) {
                PlayerDataManager plData = PlayerUtil.getAdventPlayer((ServerPlayerEntity)ev.getSource().func_76346_g());
                plData.handleOutgoingDamage(ev);
                if (DamageUtil.isMeleeDamage(ev.getSource()) && !ev.getSource().func_151517_h()) {
                    ButcheryUtil.tryCritical(ev, plData);
                    ButcheryUtil.tryBloodlustSpawn((PlayerEntity)plData.player(), ev.getEntityLiving());
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerFall(LivingFallEvent ev) {
        if (ev.getEntityLiving() instanceof ServerPlayerEntity) {
            if (ev.getDistance() > 25.0f && ev.getDamageMultiplier() > 0.0f && ItemUtil.findInventoryItem((PlayerEntity)((ServerPlayerEntity)ev.getEntity()), new ItemStack((IItemProvider)AoAItems.BLANK_REALMSTONE.get()), true, 1)) {
                ItemUtil.givePlayerItemOrDrop((PlayerEntity)((ServerPlayerEntity)ev.getEntity()), new ItemStack((IItemProvider)AoAItems.LELYETIA_REALMSTONE.get()));
            }
            PlayerDataManager plData = PlayerUtil.getAdventPlayer((ServerPlayerEntity)ev.getEntity());
            plData.handlePlayerFalling(ev);
            ExpeditionUtil.handleFallEvent(ev, plData);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityDeath(LivingDeathEvent ev) {
        if (!ev.getEntity().field_70170_p.field_72995_K) {
            if (ev.getEntity() instanceof ServerPlayerEntity) {
                PlayerDataManager plData = PlayerUtil.getAdventPlayer((ServerPlayerEntity)ev.getEntity());
                plData.stats().resetAllTribute();
                plData.handlePlayerDeath(ev);
                ReservedItem.handlePlayerDeath((PlayerEntity)plData.player());
                if (ev.getEntity().func_70089_S() && ev.getSource().func_76346_g() instanceof LivingEntity) {
                    ev.getSource().func_76346_g().func_70074_a((LivingEntity)ev.getEntity());
                }
            } else if (ev.getSource().func_76346_g() instanceof ServerPlayerEntity) {
                ItemStack blankRealmstoneStack;
                if (ev.getEntity().field_70170_p.func_201675_m().func_186058_p() == DimensionType.field_223227_a_) {
                    if (ev.getEntity().field_70170_p.func_72935_r()) {
                        PlayerDataManager plData = PlayerUtil.getAdventPlayer((ServerPlayerEntity)ev.getSource().func_76346_g());
                        plData.stats().addTribute(Deities.EREBON, 8);
                        plData.stats().addTribute(Deities.LUXON, -8);
                    }
                } else if (ev.getEntity().field_70170_p.func_201675_m().func_186058_p() == AoADimensions.DEEPLANDS.type()) {
                    if (ev.getEntityLiving() instanceof FlyingEntity) {
                        ev.getEntityLiving().func_70099_a(new ItemStack((IItemProvider)AoAItems.MUSIC_DISC_CAVERNS.get()), 0.5f);
                    }
                } else if (ev.getEntity().field_70170_p.func_201675_m().func_186058_p() == AoADimensions.CRYSTEVIA.type() && ev.getEntity().getClass().toString().contains("Construct") && (blankRealmstoneStack = ItemUtil.getStackFromInventory((PlayerEntity)((ServerPlayerEntity)ev.getSource().func_76346_g()), (Item)AoAItems.BLANK_REALMSTONE.get())) != null) {
                    BlankRealmstone.handleAncientCavernTask(blankRealmstoneStack, ev.getEntityLiving(), (PlayerEntity)((ServerPlayerEntity)ev.getSource().func_76346_g()));
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerChangeEquipment(LivingEquipmentChangeEvent ev) {
        if (ev.getEntityLiving() instanceof ServerPlayerEntity) {
            PlayerUtil.getAdventPlayer((ServerPlayerEntity)ev.getEntityLiving()).equipment().markDirty();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent ev) {
        if (!ev.isEndConquered() && ev.getEntityLiving() instanceof ServerPlayerEntity) {
            PlayerUtil.getAdventPlayer((ServerPlayerEntity)ev.getEntityLiving()).handlePlayerRespawn(ev);
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone ev) {
        if (ev.getEntityLiving() instanceof ServerPlayerEntity) {
            PlayerUtil.clonePlayerData((ServerPlayerEntity)ev.getOriginal(), (ServerPlayerEntity)ev.getEntityLiving());
        }
    }

    @SubscribeEvent
    public static void onWorldChange(PlayerEvent.PlayerChangedDimensionEvent ev) {
        if (ev.getEntityLiving() instanceof ServerPlayerEntity) {
            PlayerUtil.getAdventPlayer((ServerPlayerEntity)ev.getEntityLiving()).stats().resetAllTribute();
        }
        if (ev.getFrom() == AoADimensions.LELYETIA.type()) {
            ev.getEntityLiving().func_189654_d(false);
        }
    }

    public static void onBlockHarvest(BlockEvent.HarvestDropsEvent ev) {
        PlayerDataManager plData;
        int lvl;
        ServerPlayerEntity pl = (ServerPlayerEntity)ev.getHarvester();
        Item tool = pl.func_184586_b(Hand.MAIN_HAND).func_77973_b();
        if (tool instanceof SpecialHarvestTool) {
            ((SpecialHarvestTool)tool).doHarvestEffect(ev);
        }
        if (!(ev.getHarvester() instanceof ServerPlayerEntity)) {
            return;
        }
        Block bl = ev.getState().func_177230_c();
        boolean crop = bl.func_203417_a(BlockTags.field_226152_ab_);
        boolean leaves = bl.func_203417_a(BlockTags.field_206952_E);
        if (crop || bl.func_203417_a(BlockTags.field_226149_I_) || bl instanceof VineBlock || leaves) {
            if (!(bl instanceof CropsBlock) || ((CropsBlock)bl).func_185525_y(ev.getState())) {
                if (crop && ev.getWorld().func_201672_e().func_72935_r()) {
                    PlayerUtil.getAdventPlayer(pl).stats().addTribute(Deities.SELYAN, 2);
                    if (RandomUtil.oneInNChance(2000)) {
                        pl.func_70099_a(new ItemStack((IItemProvider)AoAWeapons.GARDENER.get()), 0.0f);
                    }
                }
                if (leaves ? RandomUtil.oneInNChance(35) : RandomUtil.oneInNChance(crop ? 6 : 8)) {
                    AnimaStoneEntity animaStone = new AnimaStoneEntity(ev.getWorld().func_201672_e(), ev.getPos());
                    ev.getWorld().func_184133_a(null, ev.getPos(), (SoundEvent)AoASounds.HEART_STONE_SPAWN.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                    ev.getWorld().func_217376_c((Entity)animaStone);
                }
            }
        } else if (ev.getState().func_185904_a() == Material.field_151576_e && ev.getState().func_200015_d((IBlockReader)ev.getWorld(), ev.getPos())) {
            PlayerDataManager plData2 = PlayerUtil.getAdventPlayer(pl);
            int lvl2 = plData2.stats().getLevel(Skills.FORAGING);
            if ((ev.getState().func_185887_b((IBlockReader)ev.getWorld(), ev.getPos()) > 1.0f || RandomUtil.fiftyFifty()) && ForagingUtil.shouldGetLoot(lvl2)) {
                ev.getDrops().addAll(ForagingUtil.getLoot(pl, ev.getPos()));
                if (plData2.equipment().getCurrentFullArmourSet() == AdventArmour.Type.FORAGING) {
                    ev.getDrops().addAll(ForagingUtil.getLoot(pl, ev.getPos()));
                }
                ev.getWorld().func_184133_a(null, ev.getPos(), (SoundEvent)AoASounds.SKILL_LOOT.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                if (ev.getWorld().func_201675_m().func_186058_p() == DimensionType.field_223227_a_ && ev.getWorld().func_201672_e().func_72935_r()) {
                    plData2.stats().addTribute(Deities.PLUTON, 11 - lvl2 / 10);
                }
            }
        } else if (bl.func_203417_a(BlockTags.field_200031_h) && LoggingUtil.shouldGetLoot(lvl = (plData = PlayerUtil.getAdventPlayer(pl)).stats().getLevel(Skills.LOGGING))) {
            if (RandomUtil.fiftyFifty()) {
                ev.getDrops().addAll(LoggingUtil.getLoot(pl, ev.getPos()));
                if (plData.equipment().getCurrentFullArmourSet() == AdventArmour.Type.LOGGING) {
                    ev.getDrops().addAll(LoggingUtil.getLoot(pl, ev.getPos()));
                }
            } else {
                ItemStack duplicateStack = ItemStack.field_190927_a;
                for (ItemStack stack : ev.getDrops()) {
                    if (stack.func_77973_b() != Item.func_150898_a((Block)bl)) continue;
                    duplicateStack = stack.func_77946_l();
                    duplicateStack.func_190920_e(lvl > 50 ? 2 : 1);
                    plData.stats().addXp(Skills.LOGGING, (float)Math.pow(lvl, 1.65) * 3.0f, false, false);
                    break;
                }
                if (!duplicateStack.func_190926_b()) {
                    ev.getDrops().add(duplicateStack);
                }
            }
            if (ev.getWorld().func_201675_m().func_186058_p() == DimensionType.field_223227_a_) {
                plData.stats().addTribute(Deities.PLUTON, 11 - lvl / 10);
            }
            ev.getWorld().func_184133_a(null, ev.getPos(), (SoundEvent)AoASounds.SKILL_LOOT.get(), SoundCategory.MASTER, 1.0f, 1.0f);
        }
        if (bl.func_203417_a(Tags.Blocks.ORES) && ev.getPos().func_177956_o() <= 5 && ItemUtil.findInventoryItem((PlayerEntity)pl, new ItemStack((IItemProvider)AoAItems.BLANK_REALMSTONE.get()), true, 1)) {
            ItemUtil.givePlayerItemOrDrop((PlayerEntity)pl, new ItemStack((IItemProvider)AoAItems.DEEPLANDS_REALMSTONE.get()));
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent ev) {
        if (!WorldUtil.canModifyBlock(ev.getWorld(), ev.getPos(), (Entity)ev.getPlayer())) {
            ev.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent ev) {
        ServerPlayerEntity pl;
        if (!WorldUtil.canModifyBlock(ev.getWorld(), ev.getPos(), ev.getEntity())) {
            ev.setCanceled(true);
            return;
        }
        if (ev.getEntity() instanceof ServerPlayerEntity && PlayerUtil.isWearingFullSet(pl = (ServerPlayerEntity)ev.getEntity(), AdventArmour.Type.HYDRANGIC) && ev.getPlacedBlock().func_177230_c() instanceof IGrowable && BoneMealItem.applyBonemeal((ItemStack)new ItemStack((IItemProvider)Items.field_196106_bc), (World)ev.getWorld().func_201672_e(), (BlockPos)ev.getPos(), (PlayerEntity)pl)) {
            ev.getWorld().func_217379_c(2005, ev.getPos(), 0);
            pl.field_71071_by.func_70449_g(4.0f);
        }
    }

    @SubscribeEvent
    public static void onEmptyBucketUse(FillBucketEvent ev) {
        PlayerEntity relevantPlayer;
        DimensionType dimType = ev.getWorld().func_201675_m().func_186058_p();
        if (!(dimType != AoADimensions.ANCIENT_CAVERN.type() && dimType != AoADimensions.IMMORTALLIS.type() || (relevantPlayer = PlayerUtil.getPlayerOrOwnerIfApplicable(ev.getEntity())) != null && relevantPlayer.func_184812_l_())) {
            ev.setCanceled(true);
            ev.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onPlayerWakeup(PlayerWakeUpEvent ev) {
        if (ev.getEntityLiving() instanceof ServerPlayerEntity && ev.getEntityLiving().field_70170_p.func_201675_m().func_186058_p() == DimensionType.field_223227_a_) {
            PlayerUtil.getAdventPlayer((ServerPlayerEntity)ev.getEntityLiving()).stats().resetAllTribute();
            OverworldEvents.doWorldStartCheck(ev.getEntityLiving().field_70170_p);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent ev) {
        if (ev.getEntityLiving() instanceof ServerPlayerEntity) {
            ServerPlayerEntity pl = (ServerPlayerEntity)ev.getEntityLiving();
            UUID uuid = pl.func_146103_bH().getId();
            String msg = null;
            if (uuid.toString().equals("2a459b511-ca45-43d8-808d-f0eb30a63be4")) {
                msg = TextFormatting.DARK_RED + "It begins...Is this the end?";
                for (int i = 0; i < 16; ++i) {
                    pl.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197594_E, true, pl.func_226277_ct_(), pl.func_226278_cu_() + 0.2, pl.func_226281_cx_(), (double)RandomUtil.randomValueUpTo(0.1f) - 0.05, (double)RandomUtil.randomValueUpTo(0.1f) - 0.05, (double)RandomUtil.randomValueUpTo(0.1f) - 0.05);
                }
            } else if (AoAHalos.isCrazyDonator(uuid)) {
                msg = TextFormatting.LIGHT_PURPLE + "They approach. Tremble before them.";
            }
            if (msg != null) {
                pl.func_184102_h().func_184103_al().func_148539_a((ITextComponent)new StringTextComponent(msg));
            }
            OverworldEvents.alertNewPlayer(pl.field_70170_p, pl);
            PlayerDataManager plData = PlayerUtil.getAdventPlayer(pl);
            PlayerDataManager.PlayerStats stats = plData.stats();
            if (((Boolean)AoAConfig.COMMON.skillsEnabled.get()).booleanValue()) {
                for (Skills sk : Skills.values()) {
                    AoAPackets.messagePlayer(pl, new SkillDataPacket(sk.id, stats.getLevelForDisplay(sk), stats.getExp(sk), stats.getSkillData(Skills.EXPEDITION)));
                }
                EntityUtil.applyAttributeModifierSafely((LivingEntity)pl, SharedMonsterAttributes.field_111267_a, InnervationUtil.getHealthModifier(stats.getLevel(Skills.INNERVATION)));
            }
            if (((Boolean)AoAConfig.COMMON.resourcesEnabled.get()).booleanValue()) {
                AoAPackets.messagePlayer(pl, new TributeDataPacket(stats.getTribute(Deities.EREBON), stats.getTribute(Deities.LUXON), stats.getTribute(Deities.PLUTON), stats.getTribute(Deities.SELYAN)));
                AoAPackets.messagePlayer(pl, new ResourceDataPacket(stats.getResourceValue(Resources.CREATION), stats.getResourceValue(Resources.ENERGY), stats.getResourceValue(Resources.RAGE), stats.getResourceValue(Resources.SOUL), plData.isRevengeActive()));
            }
            AoAHalos.syncWithNewClient(pl);
            PlayerAdvancements plAdvancements = pl.func_192039_O();
            Advancement rootAdv = AdvancementUtil.getAdvancement(new ResourceLocation("aoa3", "overworld/root"));
            if (rootAdv == null) {
                Logging.logMessage(Level.WARN, "Unable to find inbuilt advancements, another mod is breaking things.");
                if (((Boolean)AoAConfig.COMMON.doVerboseDebugging.get()).booleanValue()) {
                    Logging.logStatusMessage("Printing out current advancements list...");
                    pl.func_184102_h().func_191949_aK().func_195438_b().forEach(advancement -> Logging.logMessage(Level.INFO, advancement.func_192067_g().toString()));
                }
            } else if (!plAdvancements.func_192747_a(rootAdv).func_192105_a()) {
                plAdvancements.func_192750_a(AdvancementUtil.getAdvancement(new ResourceLocation("aoa3", "overworld/by_the_books")), "legitimate");
                plAdvancements.func_192750_a(rootAdv, "playerjoin");
            }
        }
    }

    @SubscribeEvent
    public static void onItemToss(ItemTossEvent ev) {
        World world = ev.getPlayer().func_130014_f_();
        if (ev.getPlayer() instanceof ServerPlayerEntity) {
            ItemEntity entityItem = ev.getEntityItem();
            Item item = entityItem.func_92059_d().func_77973_b();
            if (item == AoAItems.BLANK_REALMSTONE.get()) {
                if (ev.getPlayer().func_180799_ab()) {
                    ItemUtil.givePlayerItemOrDrop(ev.getPlayer(), new ItemStack((IItemProvider)AoAItems.NETHER_REALMSTONE.get()));
                    ev.getEntityItem().func_70106_y();
                }
            } else if (item instanceof BossSpawningItem) {
                if (world.func_175659_aa() == Difficulty.PEACEFUL) {
                    PlayerUtil.getAdventPlayer((ServerPlayerEntity)ev.getPlayer()).sendThrottledChatMessage("message.feedback.spawnBoss.difficultyFail", new Object[0]);
                    return;
                }
                ev.setCanceled(true);
                world.func_217376_c((Entity)BossSpawningItem.newBossEntityItemFromExisting(entityItem, ev.getPlayer()));
                BossSpawningItem bossItem = (BossSpawningItem)item;
                if (bossItem.getThrowingSound() != null) {
                    world.func_184148_a(null, entityItem.func_226277_ct_(), entityItem.func_226277_ct_(), entityItem.func_226281_cx_(), bossItem.getThrowingSound(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerPickupXp(PlayerXpEvent.PickupXp ev) {
        ItemStack stack;
        PlayerEntity pl = ev.getPlayer();
        if (!pl.field_70170_p.field_72995_K && ev.getOrb().field_70530_e > 0 && (stack = ItemUtil.getStackFromInventory(pl, (Item)AoAItems.EXP_FLASK.get())) != null) {
            ExpFlask.addExp(stack, ev.getOrb().field_70530_e);
            ev.setCanceled(true);
            ev.getOrb().field_70530_e = 0;
            ev.getOrb().func_70106_y();
        }
    }

    @SubscribeEvent
    public static void onPlayerFishing(ItemFishedEvent ev) {
        if (!ev.getPlayer().field_70170_p.func_201670_d() && RandomUtil.fiftyFifty()) {
            World world = ev.getPlayer().field_70170_p;
            LootTableManager lootTableManager = world.func_73046_m().func_200249_aQ();
            LootTable lootTable = RandomUtil.oneInNChance(20) ? lootTableManager.func_186521_a(new ResourceLocation("aoa3", "skills/hauling_treasure")) : lootTableManager.func_186521_a(new ResourceLocation("aoa3", "skills/hauling_fish"));
            List loot = lootTable.func_216113_a(new LootContext.Builder((ServerWorld)world).func_216015_a(LootParameters.field_216286_f, (Object)ev.getHookEntity().func_180425_c()).func_216015_a(LootParameters.field_216281_a, (Object)ev.getPlayer()).func_216022_a(LootParameterSets.field_216264_e));
            if (!loot.isEmpty()) {
                FishingBobberEntity hook = ev.getHookEntity();
                LivingEntity fisher = ev.getEntityLiving();
                ItemEntity drop = new ItemEntity(fisher.field_70170_p, hook.func_226277_ct_(), hook.func_226278_cu_(), hook.func_226281_cx_(), (ItemStack)loot.get(0));
                double velocityX = fisher.func_226277_ct_() - hook.func_226277_ct_();
                double velocityY = fisher.func_226278_cu_() - hook.func_226278_cu_();
                double velocityZ = fisher.func_226281_cx_() - hook.func_226281_cx_();
                double velocity = MathHelper.func_76133_a((double)(velocityX * velocityX + velocityY * velocityY + velocityZ * velocityZ));
                drop.func_213293_j(velocityX * 0.1, velocityY * 0.1 + (double)MathHelper.func_76133_a((double)velocity) * 0.08, velocityZ * 0.1);
                fisher.field_70170_p.func_217376_c((Entity)drop);
                loot.remove(0);
                ev.setCanceled(true);
            }
            if (!loot.isEmpty()) {
                for (ItemStack item : loot) {
                    ev.getHookEntity().func_199701_a_(item);
                }
            }
        }
        if (ev.getEntityLiving().field_70170_p.func_201675_m().func_186058_p() == AoADimensions.LBOREAN.type() && RandomUtil.oneInNChance(10)) {
            FishingBobberEntity hook = ev.getHookEntity();
            LivingEntity fisher = ev.getEntityLiving();
            ItemEntity drop = new ItemEntity(fisher.field_70170_p, hook.func_226277_ct_(), hook.func_226278_cu_(), hook.func_226281_cx_(), new ItemStack((IItemProvider)AoAItems.CALL_OF_THE_DRAKE.get()));
            double velocityX = fisher.func_226277_ct_() - hook.func_226277_ct_();
            double velocityY = fisher.func_226278_cu_() - hook.func_226278_cu_();
            double velocityZ = fisher.func_226281_cx_() - hook.func_226281_cx_();
            double velocity = MathHelper.func_76133_a((double)(velocityX * velocityX + velocityY * velocityY + velocityZ * velocityZ));
            drop.func_213293_j(velocityX * 0.1, velocityY * 0.1 + (double)MathHelper.func_76133_a((double)velocity) * 0.08, velocityZ * 0.1);
            fisher.field_70170_p.func_217376_c((Entity)drop);
        }
    }
}

