/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.event.dimension;

import java.util.HashSet;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tslat.aoa3.common.registration.AoAEntitySpawns;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.AoAWeapons;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.constant.Deities;
import net.tslat.aoa3.util.player.PlayerDataManager;
import net.tslat.aoa3.util.player.PlayerUtil;

@Mod.EventBusSubscriber(modid="aoa3")
public class OverworldEvents {
    private static final Random eventRand = new Random();
    private static long lastWorldCheckTime = 0L;
    private static final HashSet<Event> events = new HashSet(Event.values().length);

    @SubscribeEvent
    public static void onOverworldtick(TickEvent.WorldTickEvent ev) {
        if (ev.phase == TickEvent.Phase.START && !ev.world.func_201670_d() && ev.world.func_201675_m().func_186058_p() == DimensionType.field_223227_a_) {
            OverworldEvents.doTickCheck(ev);
        }
    }

    public static void doTickCheck(TickEvent.WorldTickEvent ev) {
        if (ev.world.func_82737_E() <= 24000L || ev.phase != TickEvent.Phase.START || !(ev.world instanceof ServerWorld)) {
            return;
        }
        ServerWorld world = (ServerWorld)ev.world;
        int time = (int)(world.func_72820_D() % 24000L);
        switch (time) {
            case 480: {
                if (!((Boolean)AoAConfig.SERVER.overworldEventsEnabled.get()).booleanValue()) break;
                eventRand.setSeed(world.func_72905_C() + world.func_82737_E());
                if (RandomUtil.percentChance((Double)AoAConfig.SERVER.bigDayEventChance.get())) {
                    OverworldEvents.activateEvent(world, Event.BIG_DAY);
                }
                if (RandomUtil.percentChance((Double)AoAConfig.SERVER.creepDayEventChance.get())) {
                    OverworldEvents.activateEvent(world, Event.CREEP_DAY);
                }
                if (!RandomUtil.percentChance((Double)AoAConfig.SERVER.deathDayEventChance.get())) break;
                OverworldEvents.activateEvent(world, Event.DEATH_DAY);
                break;
            }
            case 12500: {
                for (ServerPlayerEntity pl : world.func_217369_A()) {
                    PlayerDataManager plData = PlayerUtil.getAdventPlayer(pl);
                    boolean tributed = false;
                    int luxon = plData.stats().getTribute(Deities.LUXON);
                    int selyan = plData.stats().getTribute(Deities.SELYAN);
                    int pluton = plData.stats().getTribute(Deities.PLUTON);
                    int erebon = plData.stats().getTribute(Deities.EREBON);
                    if (pluton == 200) {
                        pl.func_145747_a((ITextComponent)LocaleUtil.getLocaleMessage("message.event.tribute.pluton", TextFormatting.GOLD));
                        tributed = true;
                    }
                    if (luxon == 200) {
                        pl.func_145747_a((ITextComponent)LocaleUtil.getLocaleMessage("message.event.tribute.luxon", TextFormatting.AQUA));
                        tributed = true;
                    }
                    if (selyan == 200) {
                        pl.func_145747_a((ITextComponent)LocaleUtil.getLocaleMessage("message.event.tribute.selyan", TextFormatting.GREEN));
                        tributed = true;
                    }
                    if (erebon == 200) {
                        pl.func_145747_a((ITextComponent)LocaleUtil.getLocaleMessage("message.event.tribute.erebon", TextFormatting.DARK_RED));
                        tributed = true;
                    }
                    if (pluton >= 100 && luxon >= 100 && erebon >= 100 && selyan >= 100) {
                        pl.func_145747_a((ITextComponent)LocaleUtil.getLocaleMessage("message.event.tribute.krasaun", TextFormatting.LIGHT_PURPLE));
                        pl.func_195064_c(new EffectInstance(Effects.field_76439_r, 6000, 0, true, false));
                        tributed = true;
                        if (pluton == 200 && luxon == 200 && erebon == 200 && selyan == 200 && ((Boolean)AoAConfig.COMMON.resourcesEnabled.get()).booleanValue()) {
                            ItemUtil.givePlayerItemOrDrop((PlayerEntity)pl, new ItemStack((IItemProvider)AoAWeapons.HOLY_SWORD.get()));
                        }
                    }
                    if (!tributed) continue;
                    world.func_184148_a(null, pl.func_226277_ct_(), pl.func_226278_cu_(), pl.func_226281_cx_(), (SoundEvent)AoASounds.TRIBUTE_SUCCESS.get(), SoundCategory.AMBIENT, 1.0f, 1.0f);
                }
                break;
            }
            case 12600: {
                if (!((Boolean)AoAConfig.SERVER.overworldEventsEnabled.get()).booleanValue()) break;
                eventRand.setSeed(world.func_72905_C() + world.func_82737_E());
                if (RandomUtil.percentChance((Double)AoAConfig.SERVER.soulScurryEventChance.get())) {
                    OverworldEvents.activateEvent(world, Event.SOUL_SCURRY);
                }
                if (RandomUtil.percentChance((Double)AoAConfig.SERVER.bloodHuntEventChance.get())) {
                    OverworldEvents.activateEvent(world, Event.BLOOD_HUNT);
                }
                if (RandomUtil.percentChance((Double)AoAConfig.SERVER.lunarInvasionEventChance.get())) {
                    OverworldEvents.activateEvent(world, Event.LUNAR_INVASION);
                }
                if (!((Boolean)AoAConfig.SERVER.fullMoonEventEnabled.get()).booleanValue() || world.func_130001_d() != 1.0f) break;
                OverworldEvents.activateEvent(world, Event.FULL_MOON);
                break;
            }
            case 12000: 
            case 12020: 
            case 12040: 
            case 13005: {
                OverworldEvents.deactivateEvent(world, Event.BIG_DAY);
                OverworldEvents.deactivateEvent(world, Event.CREEP_DAY);
                OverworldEvents.deactivateEvent(world, Event.DEATH_DAY);
                break;
            }
            case 23031: {
                for (ServerPlayerEntity pl : world.func_217369_A()) {
                    PlayerUtil.getAdventPlayer(pl).stats().resetAllTribute();
                }
                break;
            }
            case 5: 
            case 1005: 
            case 23060: 
            case 23080: 
            case 23100: {
                OverworldEvents.deactivateEvent(world, Event.SOUL_SCURRY);
                OverworldEvents.deactivateEvent(world, Event.BLOOD_HUNT);
                OverworldEvents.deactivateEvent(world, Event.LUNAR_INVASION);
                OverworldEvents.deactivateEvent(world, Event.FULL_MOON);
                break;
            }
        }
    }

    public static void activateEvent(ServerWorld world, @Nonnull Event event) {
        if (!events.contains((Object)event)) {
            events.add(event);
            AoAEntitySpawns.addEventSpawns(event);
            ITextComponent message = OverworldEvents.getEventMessage(event, false);
            SoundEvent sound = null;
            switch (event) {
                case BIG_DAY: {
                    sound = (SoundEvent)AoASounds.BIG_DAY_START.get();
                    break;
                }
                case BLOOD_HUNT: {
                    sound = (SoundEvent)AoASounds.BLOOD_HUNT_START.get();
                    break;
                }
                case CREEP_DAY: {
                    sound = (SoundEvent)AoASounds.CREEP_DAY_START.get();
                    break;
                }
                case DEATH_DAY: {
                    sound = (SoundEvent)AoASounds.DEATH_DAY_START.get();
                    break;
                }
                case FULL_MOON: {
                    break;
                }
                case LUNAR_INVASION: {
                    sound = (SoundEvent)AoASounds.LUNAR_INVASION_START.get();
                    break;
                }
                case SOUL_SCURRY: {
                    sound = (SoundEvent)AoASounds.SOUL_SCURRY_START.get();
                }
            }
            for (ServerPlayerEntity pl : world.func_217369_A()) {
                pl.func_145747_a(message);
                if (sound == null) continue;
                world.func_184148_a(null, pl.func_226277_ct_(), pl.func_226278_cu_(), pl.func_226281_cx_(), sound, SoundCategory.AMBIENT, 1.0f, 1.0f);
            }
        }
    }

    private static ITextComponent getEventMessage(Event event, boolean isEnding) {
        switch (event) {
            case BIG_DAY: {
                return LocaleUtil.getLocaleMessage("message.event." + (isEnding ? "end" : "start") + ".bigDay", TextFormatting.GOLD);
            }
            case BLOOD_HUNT: {
                return LocaleUtil.getLocaleMessage("message.event." + (isEnding ? "end" : "start") + ".bloodHunt", TextFormatting.DARK_RED);
            }
            case CREEP_DAY: {
                return LocaleUtil.getLocaleMessage("message.event." + (isEnding ? "end" : "start") + ".creepDay", TextFormatting.GREEN);
            }
            case DEATH_DAY: {
                return LocaleUtil.getLocaleMessage("message.event." + (isEnding ? "end" : "start") + ".deathDay", TextFormatting.RED);
            }
            case FULL_MOON: {
                return LocaleUtil.getLocaleMessage("message.event." + (isEnding ? "end" : "start") + ".fullMoon", TextFormatting.GRAY);
            }
            case LUNAR_INVASION: {
                return LocaleUtil.getLocaleMessage("message.event." + (isEnding ? "end" : "start") + ".lunarInvasion", TextFormatting.LIGHT_PURPLE);
            }
            case SOUL_SCURRY: {
                return LocaleUtil.getLocaleMessage("message.event." + (isEnding ? "end" : "start") + ".soulScurry", TextFormatting.AQUA);
            }
        }
        return null;
    }

    public static void deactivateEvent(ServerWorld world, @Nonnull Event event) {
        if (events.contains((Object)event)) {
            events.remove((Object)event);
            AoAEntitySpawns.removeEventSpawns(event);
            ITextComponent message = OverworldEvents.getEventMessage(event, true);
            for (ServerPlayerEntity pl : world.func_217369_A()) {
                pl.func_145747_a(message);
            }
        }
    }

    public static boolean isEventActive(@Nonnull Event event) {
        return events.contains((Object)event);
    }

    public static void doWorldStartCheck(World world) {
        if (lastWorldCheckTime >= world.func_72820_D() - 10L) {
            return;
        }
        events.clear();
        int time = (int)(world.func_72820_D() % 24000L);
        if (time < 23000) {
            if (time >= 12600) {
                long remainder = time - 12600;
                eventRand.setSeed(world.func_72905_C() + (world.func_82737_E() - remainder));
                if (RandomUtil.percentChance((Double)AoAConfig.SERVER.soulScurryEventChance.get())) {
                    events.add(Event.SOUL_SCURRY);
                }
                if (RandomUtil.percentChance((Double)AoAConfig.SERVER.bloodHuntEventChance.get())) {
                    events.add(Event.BLOOD_HUNT);
                }
                if (RandomUtil.percentChance((Double)AoAConfig.SERVER.lunarInvasionEventChance.get())) {
                    events.add(Event.LUNAR_INVASION);
                }
                if (world.func_130001_d() == 1.0f) {
                    events.add(Event.FULL_MOON);
                }
            } else if (time >= 480) {
                long remainder = time - 480;
                eventRand.setSeed(world.func_72905_C() + (world.func_82737_E() - remainder));
                if (RandomUtil.percentChance((Double)AoAConfig.SERVER.bigDayEventChance.get())) {
                    events.add(Event.BIG_DAY);
                }
                if (RandomUtil.percentChance((Double)AoAConfig.SERVER.creepDayEventChance.get())) {
                    events.add(Event.CREEP_DAY);
                }
                if (RandomUtil.percentChance((Double)AoAConfig.SERVER.deathDayEventChance.get())) {
                    events.add(Event.DEATH_DAY);
                }
            }
        }
        lastWorldCheckTime = world.func_72820_D();
    }

    public static void alertNewPlayer(World world, ServerPlayerEntity player) {
        for (Event event : events) {
            player.func_145747_a(OverworldEvents.getEventMessage(event, false));
        }
    }

    public static enum Event {
        BIG_DAY,
        BLOOD_HUNT,
        CREEP_DAY,
        DEATH_DAY,
        LUNAR_INVASION,
        SOUL_SCURRY,
        FULL_MOON;

    }
}

