/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.integration.jei;

import java.util.ArrayList;
import java.util.Collection;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.tslat.aoa3.common.container.DivineStationContainer;
import net.tslat.aoa3.common.container.recipe.FrameBenchRecipe;
import net.tslat.aoa3.common.container.recipe.InfusionRecipe;
import net.tslat.aoa3.common.container.recipe.WhitewashingRecipe;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoARecipes;
import net.tslat.aoa3.integration.jei.ingredient.subtype.TrophySubtypeInterpreter;
import net.tslat.aoa3.integration.jei.recipe.framebench.FrameBenchRecipeCategory;
import net.tslat.aoa3.integration.jei.recipe.framebench.FrameBenchRecipeTransferInfo;
import net.tslat.aoa3.integration.jei.recipe.imbuing.ImbuingRecipeCategory;
import net.tslat.aoa3.integration.jei.recipe.imbuing.ImbuingRecipeTransferInfo;
import net.tslat.aoa3.integration.jei.recipe.infusion.InfusionRecipeCategory;
import net.tslat.aoa3.integration.jei.recipe.infusion.InfusionRecipeTransferInfo;
import net.tslat.aoa3.integration.jei.recipe.upgradekit.UpgradeKitRecipeCategory;
import net.tslat.aoa3.integration.jei.recipe.upgradekit.UpgradeKitRecipeTransferInfo;
import net.tslat.aoa3.integration.jei.recipe.whitewashing.WhitewashingRecipeCategory;
import net.tslat.aoa3.integration.jei.recipe.whitewashing.WhitewashingRecipeTransferInfo;

@JeiPlugin
public class JEIIntegration
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("aoa3", "core");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)AoABlocks.DIVINE_STATION.get()), new ResourceLocation[]{UpgradeKitRecipeCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)AoABlocks.INFUSION_TABLE.get()), new ResourceLocation[]{InfusionRecipeCategory.ID, ImbuingRecipeCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)AoABlocks.FRAME_BENCH.get()), new ResourceLocation[]{FrameBenchRecipeCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)AoABlocks.WHITEWASHING_TABLE.get()), new ResourceLocation[]{WhitewashingRecipeCategory.ID});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new UpgradeKitRecipeTransferInfo());
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new ImbuingRecipeTransferInfo());
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new InfusionRecipeTransferInfo());
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new FrameBenchRecipeTransferInfo());
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new WhitewashingRecipeTransferInfo());
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (Minecraft.func_71410_x().func_147114_u() == null) {
            return;
        }
        RecipeManager recipeManager = Minecraft.func_71410_x().func_147114_u().func_199526_e();
        registration.addRecipes(this.compileUpgradeKitRecipes(recipeManager), UpgradeKitRecipeCategory.ID);
        registration.addRecipes(this.compileImbuingRecipes(recipeManager), ImbuingRecipeCategory.ID);
        registration.addRecipes(this.compileInfusionRecipes(recipeManager), InfusionRecipeCategory.ID);
        registration.addRecipes(this.compileFrameBenchRecipes(recipeManager), FrameBenchRecipeCategory.ID);
        registration.addRecipes(this.compileWhitewashingRecipes(recipeManager), WhitewashingRecipeCategory.ID);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new UpgradeKitRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new ImbuingRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new InfusionRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new FrameBenchRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new WhitewashingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter(((Block)AoABlocks.TROPHY.get()).func_199767_j(), (ISubtypeInterpreter)TrophySubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(((Block)AoABlocks.GOLD_TROPHY.get()).func_199767_j(), (ISubtypeInterpreter)TrophySubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(((Block)AoABlocks.ORNATE_TROPHY.get()).func_199767_j(), (ISubtypeInterpreter)TrophySubtypeInterpreter.INSTANCE);
    }

    private Collection<IRecipe<DivineStationContainer.DivineStationInventory>> compileUpgradeKitRecipes(RecipeManager recipeManager) {
        return recipeManager.func_215366_a((IRecipeType)AoARecipes.UPGRADE_KIT.func_76341_a()).values();
    }

    private ArrayList<WhitewashingRecipe> compileWhitewashingRecipes(RecipeManager recipeManager) {
        ArrayList<WhitewashingRecipe> whitewashingRecipes = new ArrayList<WhitewashingRecipe>(10);
        whitewashingRecipes.add(new WhitewashingRecipe(new ResourceLocation("aoa3", "whitewashing_white"), (IItemProvider)AoAItems.WHITEWASHING_SOLUTION.get(), (IItemProvider)AoABlocks.WHITEWASH_BRICKS.get()));
        whitewashingRecipes.add(new WhitewashingRecipe(new ResourceLocation("aoa3", "whitewashing_dark"), (IItemProvider)AoAItems.DARKLY_POWDER.get(), (IItemProvider)AoABlocks.DARKWASH_BRICKS.get()));
        return whitewashingRecipes;
    }

    private ArrayList<IRecipe<Inventory>> compileFrameBenchRecipes(RecipeManager recipeManager) {
        ArrayList<IRecipe<Inventory>> frameRecipes = new ArrayList<IRecipe<Inventory>>(10);
        frameRecipes.add(new FrameBenchRecipe(new ResourceLocation("aoa3", "frame_bench_crossbow"), (IItemProvider)AoAItems.CROSSBOW_FRAME.get()));
        frameRecipes.add(new FrameBenchRecipe(new ResourceLocation("aoa3", "frame_bench_blaster"), (IItemProvider)AoAItems.BLASTER_FRAME.get()));
        frameRecipes.add(new FrameBenchRecipe(new ResourceLocation("aoa3", "frame_bench_cannon"), (IItemProvider)AoAItems.CANNON_FRAME.get()));
        frameRecipes.add(new FrameBenchRecipe(new ResourceLocation("aoa3", "frame_bench_helmet"), (IItemProvider)AoAItems.HELMET_FRAME.get()));
        frameRecipes.add(new FrameBenchRecipe(new ResourceLocation("aoa3", "frame_bench_chestplate"), (IItemProvider)AoAItems.CHESTPLATE_FRAME.get()));
        frameRecipes.add(new FrameBenchRecipe(new ResourceLocation("aoa3", "frame_bench_leggings"), (IItemProvider)AoAItems.LEGGINGS_FRAME.get()));
        frameRecipes.add(new FrameBenchRecipe(new ResourceLocation("aoa3", "frame_bench_boots"), (IItemProvider)AoAItems.BOOTS_FRAME.get()));
        frameRecipes.add(new FrameBenchRecipe(new ResourceLocation("aoa3", "frame_bench_gun"), (IItemProvider)AoAItems.GUN_FRAME.get()));
        frameRecipes.add(new FrameBenchRecipe(new ResourceLocation("aoa3", "frame_bench_shotgun"), (IItemProvider)AoAItems.SHOTGUN_FRAME.get()));
        frameRecipes.add(new FrameBenchRecipe(new ResourceLocation("aoa3", "frame_bench_sniper"), (IItemProvider)AoAItems.SNIPER_FRAME.get()));
        return frameRecipes;
    }

    private ArrayList<InfusionRecipe> compileImbuingRecipes(RecipeManager recipeManager) {
        ArrayList<InfusionRecipe> imbuingRecipes = new ArrayList<InfusionRecipe>();
        for (IRecipe recipe : recipeManager.func_215366_a((IRecipeType)AoARecipes.INFUSION.func_76341_a()).values()) {
            if (!(recipe instanceof InfusionRecipe) || !((InfusionRecipe)recipe).isEnchanting()) continue;
            imbuingRecipes.add((InfusionRecipe)recipe);
        }
        return imbuingRecipes;
    }

    private ArrayList<InfusionRecipe> compileInfusionRecipes(RecipeManager recipeManager) {
        ArrayList<InfusionRecipe> infusionRecipes = new ArrayList<InfusionRecipe>();
        for (IRecipe recipe : recipeManager.func_215366_a((IRecipeType)AoARecipes.INFUSION.func_76341_a()).values()) {
            if (!(recipe instanceof InfusionRecipe) || ((InfusionRecipe)recipe).isEnchanting()) continue;
            infusionRecipes.add((InfusionRecipe)recipe);
        }
        return infusionRecipes;
    }
}

