/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.integration.jei.recipe.infusion;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.tslat.aoa3.client.gui.adventgui.AdventGuiTabPlayer;
import net.tslat.aoa3.common.container.recipe.InfusionRecipe;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.constant.Skills;

public class InfusionRecipeCategory
implements IRecipeCategory<InfusionRecipe> {
    public static final ResourceLocation ID = new ResourceLocation("aoa3", "infusion");
    private final String title = LocaleUtil.getLocaleString("recipe.aoa3.infusion");
    private final IDrawable background;
    private final IDrawable icon;
    private final ICraftingGridHelper craftingGridHelper;

    public InfusionRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation texture = new ResourceLocation("aoa3", "textures/gui/containers/infusion_table.png");
        this.background = guiHelper.createDrawable(texture, 10, 10, 156, 66);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)AoABlocks.INFUSION_TABLE.get()));
        this.craftingGridHelper = guiHelper.createCraftingGridHelper(1);
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends InfusionRecipe> getRecipeClass() {
        return InfusionRecipe.class;
    }

    public String getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(InfusionRecipe recipe, IIngredients ingredients) {
        ArrayList<ArrayList> ingredientsCollection = new ArrayList<ArrayList>();
        ArrayList<ItemStack> inputStackList = new ArrayList<ItemStack>(1);
        ItemStack output = recipe.func_77571_b();
        if (recipe.isEnchanting()) {
            output = recipe.getEnchantmentAsBook();
        }
        inputStackList.add(recipe.getRecipeInput());
        ingredientsCollection.add(inputStackList);
        for (Ingredient ing : recipe.func_192400_c()) {
            ingredientsCollection.add(Lists.newArrayList((Object[])ing.func_193365_a()));
        }
        ingredients.setInputLists(VanillaTypes.ITEM, ingredientsCollection);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)output);
    }

    public void setRecipe(IRecipeLayout recipeLayout, InfusionRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiStacks = recipeLayout.getItemStacks();
        guiStacks.init(0, false, 127, 24);
        guiStacks.init(1, true, 6, 24);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                guiStacks.init(2 + x + y * 3, true, 34 + x * 18, 6 + y * 18);
            }
        }
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        ResourceLocation recipeRegistryName = recipe.func_199560_c();
        guiStacks.set(0, (List)outputs.get(0));
        this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiStacks, inputs, 3, 3);
        recipeLayout.setShapeless();
        if (recipeRegistryName != null) {
            guiStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
                if (slotIndex == 0) {
                    if (!recipeRegistryName.func_110624_b().equals("aoa3")) {
                        tooltip.add(TextFormatting.GRAY + LocaleUtil.getLocaleString("jei.tooltip.recipe.by", recipeRegistryName.func_110624_b()));
                    }
                    if (Minecraft.func_71410_x().field_71474_y.field_82882_x || Screen.hasShiftDown()) {
                        tooltip.add(TextFormatting.DARK_GRAY + LocaleUtil.getLocaleString("jei.tooltip.recipe.id", recipeRegistryName.toString()));
                    }
                }
            });
        }
    }

    public void draw(InfusionRecipe recipe, double mouseX, double mouseY) {
        int posY;
        int posX;
        int width;
        int shadowColour;
        int textColour;
        String message;
        if (recipe == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (recipe.getInfusionReq() > 1) {
            message = LocaleUtil.getLocaleString("skills.infusion.name") + ": " + recipe.getInfusionReq();
            textColour = AdventGuiTabPlayer.getSkillLevel(Skills.INFUSION) < recipe.getInfusionReq() ? -40864 : -8323296;
            shadowColour = 0xFF000000 | (textColour & 0xFCFCFC) >> 2;
            width = mc.field_71466_p.func_78256_a(message);
            posX = 150 - width;
            posY = 10;
            mc.field_71466_p.func_211126_b(message, (float)(posX + 1), (float)posY, shadowColour);
            mc.field_71466_p.func_211126_b(message, (float)posX, (float)(posY + 1), shadowColour);
            mc.field_71466_p.func_211126_b(message, (float)(posX + 1), (float)(posY + 1), shadowColour);
            mc.field_71466_p.func_211126_b(message, (float)posX, (float)posY, textColour);
        }
        if (recipe.getMaxXp() > 0) {
            message = LocaleUtil.getLocaleString("gui.misc.skills.xp", String.valueOf(recipe.getMinXp() == recipe.getMaxXp() ? Integer.valueOf(recipe.getMaxXp()) : recipe.getMinXp() + "-" + recipe.getMaxXp()));
            textColour = -7368817;
            shadowColour = 0xFF000000 | (textColour & 0xFCFCFC) >> 2;
            width = mc.field_71466_p.func_78256_a(message);
            posX = 150 - width;
            posY = 50;
            mc.field_71466_p.func_211126_b(message, (float)(posX + 1), (float)posY, shadowColour);
            mc.field_71466_p.func_211126_b(message, (float)posX, (float)(posY + 1), shadowColour);
            mc.field_71466_p.func_211126_b(message, (float)(posX + 1), (float)(posY + 1), shadowColour);
            mc.field_71466_p.func_211126_b(message, (float)posX, (float)posY, textColour);
        }
    }
}

