/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.integration.jei.recipe.whitewashing;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.tslat.aoa3.common.container.recipe.WhitewashingRecipe;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.util.LocaleUtil;

public class WhitewashingRecipeCategory
implements IRecipeCategory<WhitewashingRecipe> {
    public static final ResourceLocation ID = new ResourceLocation("aoa3", "whitewashing");
    private final String title = LocaleUtil.getLocaleString("recipe.aoa3.whitewashing");
    private final IDrawable background;
    private final IDrawable icon;

    public WhitewashingRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation texture = new ResourceLocation("aoa3", "textures/gui/containers/basic_block.png");
        this.background = guiHelper.createDrawable(texture, 26, 22, 125, 18);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)AoABlocks.WHITEWASHING_TABLE.get()));
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<WhitewashingRecipe> getRecipeClass() {
        return WhitewashingRecipe.class;
    }

    public String getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(WhitewashingRecipe recipe, IIngredients ingredients) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(2);
        Item output = recipe.func_77571_b().func_77973_b();
        inputs.add(new ItemStack((IItemProvider)Blocks.field_150343_Z));
        if (output == ((Block)AoABlocks.WHITEWASH_BRICKS.get()).func_199767_j()) {
            inputs.add(new ItemStack((IItemProvider)AoAItems.WHITEWASHING_SOLUTION.get()));
        } else if (output == ((Block)AoABlocks.DARKWASH_BRICKS.get()).func_199767_j()) {
            inputs.add(new ItemStack((IItemProvider)AoAItems.DARKLY_POWDER.get()));
        }
        ingredients.setInputs(VanillaTypes.ITEM, inputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)new ItemStack((IItemProvider)output, 2));
    }

    public void setRecipe(IRecipeLayout recipeLayout, WhitewashingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiStacks = recipeLayout.getItemStacks();
        guiStacks.init(0, true, 0, 0);
        guiStacks.init(1, true, 49, 0);
        guiStacks.init(2, false, 107, 0);
        guiStacks.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        guiStacks.set(1, (List)ingredients.getInputs(VanillaTypes.ITEM).get(1));
        guiStacks.set(2, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }
}

