/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.player.PlayerDataManager;

public abstract class AdventArmour
extends ArmorItem {
    public AdventArmour(IArmorMaterial material, EquipmentSlotType slot) {
        super(material, slot, new Item.Properties().func_200916_a(AoAItemGroups.ARMOUR).func_200918_c(material.func_200896_a(slot)));
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return null;
    }

    public abstract Type setType();

    public void onEquip(PlayerDataManager plData, @Nullable EquipmentSlotType slot) {
    }

    public void onUnequip(PlayerDataManager plData, @Nullable EquipmentSlotType slot) {
    }

    public void addBuffs(PlayerDataManager.PlayerBuffs plBuffs, @Nullable EquipmentSlotType slot) {
    }

    public void removeBuffs(PlayerDataManager.PlayerBuffs plBuffs, @Nullable EquipmentSlotType slot) {
    }

    public void onEffectTick(PlayerDataManager plData, @Nullable HashSet<EquipmentSlotType> slots) {
    }

    public void onDamageDealt(PlayerDataManager plData, @Nullable HashSet<EquipmentSlotType> slots, LivingHurtEvent event) {
    }

    public void onPreAttackReceived(PlayerDataManager plData, @Nullable HashSet<EquipmentSlotType> slots, LivingAttackEvent event) {
    }

    public void onAttackReceived(PlayerDataManager plData, @Nullable HashSet<EquipmentSlotType> slots, LivingHurtEvent event) {
    }

    public void onPostAttackReceived(PlayerDataManager plData, @Nullable HashSet<EquipmentSlotType> slots, LivingDamageEvent event) {
    }

    public void onPlayerLandingFall(PlayerDataManager plData, @Nullable HashSet<EquipmentSlotType> slots, LivingFallEvent event) {
    }

    public void onPlayerDeath(PlayerDataManager plData, @Nullable HashSet<EquipmentSlotType> slots, LivingDeathEvent event) {
    }

    public boolean func_82789_a(ItemStack stack, ItemStack repairMaterial) {
        return false;
    }

    public boolean isSetHelmet(AdventArmour helmet) {
        return this.setType() == helmet.setType() || helmet.setType() == Type.ALL;
    }

    protected TranslationTextComponent setEffectHeader() {
        return LocaleUtil.getLocaleMessage("items.description.armour.set", TextFormatting.GOLD);
    }

    protected TranslationTextComponent pieceEffectHeader() {
        return LocaleUtil.getLocaleMessage("items.description.armour.piece", TextFormatting.GRAY);
    }

    protected TranslationTextComponent anySetEffectHeader() {
        return LocaleUtil.getLocaleMessage("items.description.armour.anySet", TextFormatting.DARK_AQUA);
    }

    public static enum Overlay {
        NIGHT_VISION_GOGGLES;

    }

    public static enum Type {
        ALACRITY,
        ALCHEMY,
        ALL,
        AMETHIND,
        ANIMA,
        ARCHAIC,
        AUGURY,
        BARON,
        BATTLEBORN,
        BIOGENIC,
        BOREIC,
        BUTCHERY,
        CANDY,
        COMMANDER,
        CREATION,
        CRYSTALLIS,
        ELECANYTE,
        EMBRODIUM,
        ENGINEERING,
        EXOPLATE,
        EXPEDITION,
        EXPLOSIVE,
        EXTRACTION,
        FORAGING,
        FUNGAL,
        GHASTLY,
        GHOULISH,
        HAULING,
        HAZMAT,
        HUNTER,
        HYDRANGIC,
        HYDROPLATE,
        ICE,
        INFERNAL,
        INFUSION,
        INNERVATION,
        KNIGHT,
        LOGGING,
        LUNAR,
        LYNDAMYTE,
        LYONIC,
        MERCURIAL,
        NECRO,
        NETHENGEIC,
        NIGHTMARE,
        NONE,
        OMNI,
        PHANTASM,
        POISON,
        PREDATIOUS,
        PRIMORDIAL,
        PURITY,
        ROCKBONE,
        ROSIDIAN,
        RUNATION,
        RUNIC,
        SHARPSHOT,
        SKELETAL,
        SPACEKING,
        SPEED,
        SUBTERRANEAN,
        UTOPIAN,
        VOID,
        WEAKEN,
        WITHER,
        ZARGONITE;

    }
}

