/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.player.PlayerDataManager;

public class BattlebornArmour
extends AdventArmour {
    private static final UUID BATTLEBORN_ARMOUR_BUFF = UUID.fromString("5cf50cfa-4298-46d1-b7ec-c648f8e8d5c9");

    public BattlebornArmour(EquipmentSlotType slot) {
        super(ItemUtil.customArmourMaterial("aoa3:battleborn", 65, new int[]{4, 8, 9, 5}, 10, SoundEvents.field_187719_p, 7.0f), slot);
    }

    @Override
    public AdventArmour.Type setType() {
        return AdventArmour.Type.BATTLEBORN;
    }

    private AttributeModifier buff(double currentValue) {
        return new AttributeModifier(BATTLEBORN_ARMOUR_BUFF, "AoABattlebornArmour", currentValue, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    @Override
    public void onDamageDealt(PlayerDataManager plData, @Nullable HashSet<EquipmentSlotType> slots, LivingHurtEvent event) {
        if (slots != null && DamageUtil.isMeleeDamage(event.getSource())) {
            int counter = plData.equipment().getCooldown("battleborn");
            int newAmount = Math.min(300, counter + slots.size() * 6);
            plData.equipment().setCooldown("battleborn", newAmount);
            EntityUtil.removeAttributeModifier((LivingEntity)plData.player(), SharedMonsterAttributes.field_188790_f, BATTLEBORN_ARMOUR_BUFF);
            EntityUtil.applyAttributeModifierSafely((LivingEntity)plData.player(), SharedMonsterAttributes.field_188790_f, this.buff(Math.min(0.65, (double)newAmount / 240.0)));
        }
    }

    @Override
    public void onEffectTick(PlayerDataManager plData, @Nullable HashSet<EquipmentSlotType> slots) {
        int counter = plData.equipment().getCooldown("battleborn");
        if (counter == 1) {
            EntityUtil.removeAttributeModifier((LivingEntity)plData.player(), SharedMonsterAttributes.field_188790_f, BATTLEBORN_ARMOUR_BUFF);
        } else if (counter > 0 && plData.player().field_70170_p.func_82737_E() % 10L == 0L) {
            EntityUtil.removeAttributeModifier((LivingEntity)plData.player(), SharedMonsterAttributes.field_188790_f, BATTLEBORN_ARMOUR_BUFF);
            EntityUtil.applyAttributeModifierSafely((LivingEntity)plData.player(), SharedMonsterAttributes.field_188790_f, this.buff(Math.min(0.65, (double)counter / 240.0)));
        }
    }

    @Override
    public void onUnequip(PlayerDataManager plData, @Nullable EquipmentSlotType slot) {
        int cooldown;
        if (slot != null && (cooldown = plData.equipment().getCooldown("battleborn")) > 0) {
            EntityUtil.removeAttributeModifier((LivingEntity)plData.player(), SharedMonsterAttributes.field_188790_f, BATTLEBORN_ARMOUR_BUFF);
            plData.equipment().setCooldown("battleborn", (int)((float)cooldown * 0.75f));
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.battleborn_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
        tooltip.add((ITextComponent)this.pieceEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.battleborn_armour.desc.2", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
    }
}

