/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.player.PlayerDataManager;

public class BiogenicArmour
extends AdventArmour {
    public BiogenicArmour(EquipmentSlotType slot) {
        super(ItemUtil.customArmourMaterial("aoa3:biogenic", 38, new int[]{3, 6, 8, 3}, 10, SoundEvents.field_187719_p, 3.0f), slot);
    }

    @Override
    public AdventArmour.Type setType() {
        return AdventArmour.Type.BIOGENIC;
    }

    @Override
    public void onEffectTick(PlayerDataManager plData, @Nullable HashSet<EquipmentSlotType> slots) {
        if (slots == null) {
            if (plData.player().func_70090_H()) {
                plData.player().func_70050_g(-10);
            }
            if (plData.player().func_208600_a(FluidTags.field_206959_a)) {
                plData.player().func_195064_c(new EffectInstance(Effects.field_76439_r, 300, 0, true, false));
            } else {
                EffectInstance nightVision = plData.player().func_70660_b(Effects.field_76439_r);
                if (nightVision != null && nightVision.func_76459_b() <= 300) {
                    plData.player().func_195063_d(Effects.field_76439_r);
                }
            }
        }
    }

    @Override
    public void onPostAttackReceived(PlayerDataManager plData, @Nullable HashSet<EquipmentSlotType> slots, LivingDamageEvent event) {
        if (slots != null && DamageUtil.isMeleeDamage(event.getSource()) && event.getSource().func_76346_g() instanceof LivingEntity) {
            ((LivingEntity)event.getSource().func_76346_g()).func_195064_c(new EffectInstance(Effects.field_76421_d, (int)event.getAmount() * 3 * slots.size(), slots.size() >= 2 ? 1 : 0, false, true));
        }
    }

    @Override
    public void onUnequip(PlayerDataManager plData, @Nullable EquipmentSlotType slot) {
        EffectInstance nightVision;
        if (slot == null && (nightVision = plData.player().func_70660_b(Effects.field_76439_r)) != null && nightVision.func_76459_b() <= 300) {
            plData.player().func_195063_d(Effects.field_76439_r);
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.biogenic_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
        tooltip.add((ITextComponent)this.pieceEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.biogenic_armour.desc.2", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
        tooltip.add((ITextComponent)this.setEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.biogenic_armour.desc.3", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
    }
}

