/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Food;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.player.PlayerDataManager;

public class CandyArmour
extends AdventArmour {
    public CandyArmour(EquipmentSlotType slot) {
        super(ItemUtil.customArmourMaterial("aoa3:candy", 59, new int[]{4, 7, 9, 4}, 10, SoundEvents.field_187719_p, 5.0f), slot);
    }

    @Override
    public AdventArmour.Type setType() {
        return AdventArmour.Type.CANDY;
    }

    @Override
    public void onEffectTick(PlayerDataManager plData, @Nullable HashSet<EquipmentSlotType> slots) {
        if (plData.player().func_71024_bL().func_75121_c() && (slots == null || plData.equipment().isCooledDown("candy_armour")) && this.findAndConsumeFood((PlayerEntity)plData.player())) {
            plData.equipment().setCooldown("candy_armour", 12000 / (slots == null ? 4 : slots.size()));
        }
    }

    private boolean findAndConsumeFood(PlayerEntity player) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            Food food;
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!stack.func_77973_b().func_219971_r() || (food = stack.func_77973_b().func_219967_s()).func_221466_a() <= 0 || !(food.func_221469_b() > 0.0f)) continue;
            player.field_71071_by.func_70299_a(i, stack.func_77973_b().func_77654_b(stack, player.field_70170_p, (LivingEntity)player));
            return true;
        }
        return false;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.candy_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
        tooltip.add((ITextComponent)this.pieceEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.candy_armour.desc.2", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
        tooltip.add((ITextComponent)this.setEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.candy_armour.desc.3", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
    }
}

