/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.player.PlayerDataManager;

public class CrystallisArmour
extends AdventArmour {
    public CrystallisArmour(EquipmentSlotType slot) {
        super(ItemUtil.customArmourMaterial("aoa3:crystallis", 56, new int[]{5, 6, 10, 3}, 10, SoundEvents.field_187719_p, 5.0f), slot);
    }

    @Override
    public AdventArmour.Type setType() {
        return AdventArmour.Type.CRYSTALLIS;
    }

    @Override
    public void onPostAttackReceived(PlayerDataManager plData, @Nullable HashSet<EquipmentSlotType> slots, LivingDamageEvent event) {
        if (event.getSource().func_76346_g() instanceof LivingEntity) {
            if (slots == null && DamageUtil.isMeleeDamage(event.getSource()) || DamageUtil.isRangedDamage(event.getSource(), (Entity)plData.player(), event.getAmount())) {
                event.getSource().func_76346_g().func_70097_a(DamageSource.func_92087_a((Entity)plData.player()), event.getAmount());
                plData.player().field_71071_by.func_70449_g(event.getAmount() * 0.5f);
            } else if (slots != null && plData.equipment().getCurrentFullArmourSet() != this.setType() && DamageUtil.isMeleeDamage(event.getSource())) {
                event.getSource().func_76346_g().func_70097_a(DamageSource.func_92087_a((Entity)plData.player()), event.getAmount() * (float)slots.size() / 4.0f);
                plData.player().field_71071_by.func_70449_g(event.getAmount() * 0.5f);
            }
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.crystallis_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
        tooltip.add((ITextComponent)this.pieceEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.crystallis_armour.desc.2", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
        tooltip.add((ITextComponent)this.setEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.crystallis_armour.desc.3", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
    }
}

