/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.tslat.aoa3.item.SkillItem;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.constant.Skills;
import net.tslat.aoa3.util.player.PlayerDataManager;

public class ExpeditionArmour
extends AdventArmour
implements SkillItem {
    public ExpeditionArmour(EquipmentSlotType slot) {
        super(ItemUtil.customArmourMaterial("aoa3:expedition", 65, new int[]{6, 7, 9, 4}, 10, SoundEvents.field_187719_p, 7.0f), slot);
    }

    @Override
    public AdventArmour.Type setType() {
        return AdventArmour.Type.EXPEDITION;
    }

    @Override
    public Skills getSkill() {
        return Skills.EXPEDITION;
    }

    @Override
    public int getLevelReq() {
        return 100;
    }

    @Override
    public void addBuffs(PlayerDataManager.PlayerBuffs plBuffs, @Nullable EquipmentSlotType slot) {
        if (slot == null) {
            plBuffs.addXpModifier(Skills.EXPEDITION, 0.3f);
        }
    }

    @Override
    public void removeBuffs(PlayerDataManager.PlayerBuffs plBuffs, @Nullable EquipmentSlotType slot) {
        if (slot == null) {
            plBuffs.removeXpModifier(Skills.EXPEDITION, 0.3f);
        }
    }

    @Override
    public void onUnequip(PlayerDataManager plData, @Nullable EquipmentSlotType slot) {
        EffectInstance nightVision;
        if (slot == null && (nightVision = plData.player().func_70660_b(Effects.field_76439_r)) != null && nightVision.func_76459_b() <= 300) {
            plData.player().func_195063_d(Effects.field_76439_r);
        }
    }

    @Override
    public void onPlayerLandingFall(PlayerDataManager plData, @Nullable HashSet<EquipmentSlotType> slots, LivingFallEvent event) {
        if (slots == null) {
            event.setDamageMultiplier(event.getDamageMultiplier() * 0.5f);
        }
    }

    @Override
    public void onEffectTick(PlayerDataManager plData, @Nullable HashSet<EquipmentSlotType> slots) {
        if (slots == null) {
            ServerPlayerEntity pl = plData.player();
            pl.func_195064_c(new EffectInstance(Effects.field_76424_c, -1, 1, true, false));
            pl.func_195064_c(new EffectInstance(Effects.field_76427_o, -1, 0, true, false));
            EffectInstance nightVision = pl.func_70660_b(Effects.field_76439_r);
            if (nightVision == null || nightVision.func_76459_b() < 250) {
                pl.func_195064_c(new EffectInstance(Effects.field_76439_r, 300, 0, true, false));
            }
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)this.setEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.expedition_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.skillXpBonus", LocaleUtil.ItemDescriptionType.BENEFICIAL, "30", LocaleUtil.getLocaleString("skills.expedition.name")));
        tooltip.add(LocaleUtil.getFormattedLevelRestrictedDescriptionText(Skills.EXPEDITION, 100));
    }
}

