/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.tslat.aoa3.item.SkillItem;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.constant.Skills;
import net.tslat.aoa3.util.player.PlayerDataManager;
import net.tslat.aoa3.util.skill.HunterUtil;

public class HunterArmour
extends AdventArmour
implements SkillItem {
    private static final AttributeModifier HUNTER_ARMOUR_KNOCKBACK = new AttributeModifier(UUID.fromString("a794717e-8b9b-4d20-b224-0a7571ddd012"), "AoAHunterArmourBuff", 0.5, AttributeModifier.Operation.ADDITION);

    public HunterArmour(EquipmentSlotType slot) {
        super(ItemUtil.customArmourMaterial("aoa3:hunter", 65, new int[]{6, 7, 9, 4}, 10, SoundEvents.field_187719_p, 7.0f), slot);
    }

    @Override
    public AdventArmour.Type setType() {
        return AdventArmour.Type.HUNTER;
    }

    @Override
    public Skills getSkill() {
        return Skills.HUNTER;
    }

    @Override
    public int getLevelReq() {
        return 100;
    }

    @Override
    public void addBuffs(PlayerDataManager.PlayerBuffs plBuffs, @Nullable EquipmentSlotType slot) {
        if (slot == null) {
            plBuffs.addXpModifier(Skills.HUNTER, 0.3f);
        }
    }

    @Override
    public void removeBuffs(PlayerDataManager.PlayerBuffs plBuffs, @Nullable EquipmentSlotType slot) {
        if (slot == null) {
            plBuffs.removeXpModifier(Skills.HUNTER, 0.3f);
        }
    }

    @Override
    public void onEquip(PlayerDataManager plData, @Nullable EquipmentSlotType slot) {
        EntityUtil.applyAttributeModifierSafely((LivingEntity)plData.player(), SharedMonsterAttributes.field_111266_c, HUNTER_ARMOUR_KNOCKBACK);
    }

    @Override
    public void onUnequip(PlayerDataManager plData, @Nullable EquipmentSlotType slot) {
        EntityUtil.removeAttributeModifier((LivingEntity)plData.player(), SharedMonsterAttributes.field_111266_c, HUNTER_ARMOUR_KNOCKBACK);
    }

    @Override
    public void onDamageDealt(PlayerDataManager plData, @Nullable HashSet<EquipmentSlotType> slots, LivingHurtEvent event) {
        if (slots == null && HunterUtil.isHunterCreature(event.getEntityLiving())) {
            event.setAmount(event.getAmount() * 1.15f);
        }
    }

    @Override
    public void onAttackReceived(PlayerDataManager plData, @Nullable HashSet<EquipmentSlotType> slots, LivingHurtEvent event) {
        if (slots == null && event.getSource().func_76346_g() instanceof LivingEntity && HunterUtil.isHunterCreature((LivingEntity)event.getSource().func_76346_g())) {
            event.setAmount(event.getAmount() * 0.85f);
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)this.setEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.hunter_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.hunter_armour.desc.2", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.hunter_armour.desc.3", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.skillXpBonus", LocaleUtil.ItemDescriptionType.BENEFICIAL, "30", LocaleUtil.getLocaleString("skills.hunter.name")));
        tooltip.add(LocaleUtil.getFormattedLevelRestrictedDescriptionText(Skills.HUNTER, 100));
    }
}

