/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.player.PlayerDataManager;

public class KnightArmour
extends AdventArmour {
    public static final AttributeModifier KNIGHT_BOOTS_BUFF = new AttributeModifier(UUID.fromString("9283b669-bc04-4055-a165-73e3a2b5ab7e"), "AoAKnightArmourBoots", 1.5, AttributeModifier.Operation.ADDITION);
    public static final AttributeModifier KNIGHT_LEGS_BUFF = new AttributeModifier(UUID.fromString("e60b8cda-a196-4922-b867-01d2422a9e8c"), "AoAKnightArmourLegs", 1.5, AttributeModifier.Operation.ADDITION);
    public static final AttributeModifier KNIGHT_CHESTPLATE_BUFF = new AttributeModifier(UUID.fromString("8ecbc122-563a-4de5-8f27-3f461ad2fb5c"), "AoAKnightArmourBody", 1.5, AttributeModifier.Operation.ADDITION);
    public static final AttributeModifier KNIGHT_HELMET_BUFF = new AttributeModifier(UUID.fromString("673ef5d8-9df5-4dbb-84f0-1da677d59f05"), "AoAKnightArmourHelmet", 1.5, AttributeModifier.Operation.ADDITION);

    public KnightArmour(EquipmentSlotType slot) {
        super(ItemUtil.customArmourMaterial("aoa3:knight", 70, new int[]{4, 8, 9, 5}, 10, SoundEvents.field_187719_p, 7.0f), slot);
    }

    @Override
    public AdventArmour.Type setType() {
        return AdventArmour.Type.KNIGHT;
    }

    @Override
    public void onEffectTick(PlayerDataManager plData, @Nullable HashSet<EquipmentSlotType> slots) {
        if (slots == null && EntityUtil.checkBelowHealthPercentThreshold((LivingEntity)plData.player(), 0.2f)) {
            plData.player().func_195064_c(new EffectInstance(Effects.field_76420_g, -1, 1, false, true));
        }
    }

    @Override
    public void onEquip(PlayerDataManager plData, @Nullable EquipmentSlotType slot) {
        if (slot != null) {
            switch (slot) {
                case FEET: {
                    EntityUtil.applyAttributeModifierSafely((LivingEntity)plData.player(), SharedMonsterAttributes.field_111267_a, KNIGHT_BOOTS_BUFF);
                    break;
                }
                case LEGS: {
                    EntityUtil.applyAttributeModifierSafely((LivingEntity)plData.player(), SharedMonsterAttributes.field_111267_a, KNIGHT_LEGS_BUFF);
                    break;
                }
                case CHEST: {
                    EntityUtil.applyAttributeModifierSafely((LivingEntity)plData.player(), SharedMonsterAttributes.field_111267_a, KNIGHT_CHESTPLATE_BUFF);
                    break;
                }
                case HEAD: {
                    EntityUtil.applyAttributeModifierSafely((LivingEntity)plData.player(), SharedMonsterAttributes.field_111267_a, KNIGHT_HELMET_BUFF);
                }
            }
        }
    }

    @Override
    public void onUnequip(PlayerDataManager plData, @Nullable EquipmentSlotType slot) {
        if (slot != null) {
            switch (slot) {
                case FEET: {
                    EntityUtil.removeAttributeModifier((LivingEntity)plData.player(), SharedMonsterAttributes.field_111267_a, KNIGHT_BOOTS_BUFF);
                    break;
                }
                case LEGS: {
                    EntityUtil.removeAttributeModifier((LivingEntity)plData.player(), SharedMonsterAttributes.field_111267_a, KNIGHT_LEGS_BUFF);
                    break;
                }
                case CHEST: {
                    EntityUtil.removeAttributeModifier((LivingEntity)plData.player(), SharedMonsterAttributes.field_111267_a, KNIGHT_CHESTPLATE_BUFF);
                    break;
                }
                case HEAD: {
                    EntityUtil.removeAttributeModifier((LivingEntity)plData.player(), SharedMonsterAttributes.field_111267_a, KNIGHT_HELMET_BUFF);
                }
            }
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)this.pieceEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.knight_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
        tooltip.add((ITextComponent)this.setEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.knight_armour.desc.2", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
    }
}

