/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.player.PlayerDataManager;

public class LyndamyteArmour
extends AdventArmour {
    public LyndamyteArmour(EquipmentSlotType slot) {
        super(ItemUtil.customArmourMaterial("aoa3:lyndamyte", 35, new int[]{3, 6, 8, 3}, 10, SoundEvents.field_187719_p, 2.0f), slot);
    }

    @Override
    public AdventArmour.Type setType() {
        return AdventArmour.Type.LYNDAMYTE;
    }

    @Override
    public void onPostAttackReceived(PlayerDataManager plData, @Nullable HashSet<EquipmentSlotType> slots, LivingDamageEvent event) {
        if (slots != null && !plData.player().field_70170_p.field_72995_K && DamageUtil.isMeleeDamage(event.getSource()) && field_77697_d.nextFloat() < 0.25f * (float)slots.size()) {
            event.getSource().func_76346_g().func_70015_d(5);
        }
    }

    @Override
    public void onDamageDealt(PlayerDataManager plData, @Nullable HashSet<EquipmentSlotType> slots, LivingHurtEvent event) {
        if (slots == null && DamageUtil.isMeleeDamage(event.getSource())) {
            event.getEntityLiving().func_70015_d(5);
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)this.pieceEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.lyndamyte_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
        tooltip.add((ITextComponent)this.setEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.lyndamyte_armour.desc.2", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
    }
}

