/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.player.PlayerDataManager;

public class LyonicArmour
extends AdventArmour {
    public LyonicArmour(EquipmentSlotType slot) {
        super(ItemUtil.customArmourMaterial("aoa3:lyonic", 56, new int[]{4, 7, 8, 4}, 10, SoundEvents.field_187719_p, 5.0f), slot);
    }

    @Override
    public AdventArmour.Type setType() {
        return AdventArmour.Type.LYONIC;
    }

    @Override
    public void onDamageDealt(PlayerDataManager plData, @Nullable HashSet<EquipmentSlotType> slots, LivingHurtEvent event) {
        if (slots != null) {
            ItemEntity item;
            ServerPlayerEntity pl = plData.player();
            float range = 1.5f * (float)slots.size();
            Iterator iterator = plData.player().field_70170_p.func_217357_a(ItemEntity.class, new AxisAlignedBB(pl.func_226277_ct_() - (double)range, pl.func_226278_cu_() - (double)range, pl.func_226281_cx_() - (double)range, pl.func_226277_ct_() + (double)range, pl.func_226278_cu_() + (double)range, pl.func_226281_cx_() + (double)range)).iterator();
            for (int pulledCount = 0; iterator.hasNext() && pulledCount <= 200 && this.canPullItem(item = (ItemEntity)iterator.next()); ++pulledCount) {
                EntityUtil.pullEntityIn((Entity)pl, (Entity)item, 0.1f);
            }
        } else {
            ServerPlayerEntity pl = plData.player();
            Iterator iterator = plData.player().field_70170_p.func_217357_a(ExperienceOrbEntity.class, new AxisAlignedBB(pl.func_226277_ct_() - 6.0, pl.func_226278_cu_() - 6.0, pl.func_226281_cx_() - 6.0, pl.func_226277_ct_() + 6.0, pl.func_226278_cu_() + 6.0, pl.func_226281_cx_() + 6.0)).iterator();
            for (int pulledCount = 0; iterator.hasNext() && pulledCount <= 200; ++pulledCount) {
                EntityUtil.pullEntityIn((Entity)pl, (Entity)iterator.next(), 0.1f);
            }
        }
    }

    private boolean canPullItem(ItemEntity item) {
        return item.func_70089_S() && !item.func_92059_d().func_190926_b() && !item.func_174874_s();
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.lyonic_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
        tooltip.add((ITextComponent)this.pieceEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.lyonic_armour.desc.2", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
        tooltip.add((ITextComponent)this.setEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.lyonic_armour.desc.3", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
    }
}

