/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.tslat.aoa3.common.registration.AoAEnchantments;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.player.PlayerDataManager;

public class NecroArmour
extends AdventArmour {
    public NecroArmour(EquipmentSlotType slot) {
        super(ItemUtil.customArmourMaterial("aoa3:necro", 64, new int[]{5, 8, 9, 4}, 10, SoundEvents.field_187719_p, 7.0f), slot);
    }

    @Override
    public AdventArmour.Type setType() {
        return AdventArmour.Type.NECRO;
    }

    @Override
    public void onEffectTick(PlayerDataManager plData, @Nullable HashSet<EquipmentSlotType> slots) {
        super.onEffectTick(plData, slots);
    }

    @Override
    public void onPostAttackReceived(PlayerDataManager plData, @Nullable HashSet<EquipmentSlotType> slots, LivingDamageEvent event) {
        if (slots == null && !DamageUtil.isEnvironmentalDamage(event.getSource()) && event.getAmount() > plData.player().func_110143_aJ() && plData.equipment().isCooledDown("necro_armour")) {
            ServerPlayerEntity pl = plData.player();
            event.setAmount(0.0f);
            plData.equipment().setCooldown("necro_armour", 72000);
            pl.field_71071_by.func_70449_g(500.0f);
            if (pl.func_110143_aJ() < 4.0f) {
                pl.func_70606_j(4.0f);
            }
            ((ServerWorld)pl.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197633_z, pl.func_226277_ct_(), pl.func_174813_aQ().field_72337_e, pl.func_226281_cx_(), 5, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void onPlayerDeath(PlayerDataManager plData, @Nullable HashSet<EquipmentSlotType> slots, LivingDeathEvent event) {
        if (slots != null) {
            int count = slots.size();
            PlayerInventory inv = plData.player().field_71071_by;
            for (int inventoryIndex = 0; count > 0 && inventoryIndex < inv.func_70302_i_(); ++inventoryIndex) {
                ItemStack stack = inv.func_70301_a(inventoryIndex);
                if (stack.func_190926_b() || EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)AoAEnchantments.INTERVENTION.get()), (ItemStack)stack) != 0 || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_190940_C, (ItemStack)stack) != 0) continue;
                plData.storeInterventionItem(stack);
                inv.func_70299_a(inventoryIndex, ItemStack.field_190927_a);
                --count;
            }
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.necro_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.necro_armour.desc.2", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
        tooltip.add((ITextComponent)this.pieceEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.necro_armour.desc.3", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
        tooltip.add((ITextComponent)this.setEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.necro_armour.desc.4", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
    }
}

