/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.player.PlayerDataManager;

public class NethengeicArmour
extends AdventArmour {
    public NethengeicArmour(EquipmentSlotType slot) {
        super(ItemUtil.customArmourMaterial("aoa3:nethengeic", 41, new int[]{3, 7, 8, 4}, 10, SoundEvents.field_187719_p, 3.0f), slot);
    }

    @Override
    public AdventArmour.Type setType() {
        return AdventArmour.Type.NETHENGEIC;
    }

    @Override
    public void onDamageDealt(PlayerDataManager plData, @Nullable HashSet<EquipmentSlotType> slots, LivingHurtEvent event) {
        if (slots == null && plData.player().func_70027_ad()) {
            event.setAmount(event.getAmount() * 1.5f);
        }
        if (slots != null && event.getEntityLiving().func_70027_ad()) {
            event.setAmount(event.getAmount() * (1.0f + 0.1f * (float)slots.size()));
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)this.pieceEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.nethengeic_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
        tooltip.add((ITextComponent)this.setEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.nethengeic_armour.desc.2", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
    }
}

