/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.player.PlayerDataManager;

public class PrimordialArmour
extends AdventArmour {
    public PrimordialArmour(EquipmentSlotType slot) {
        super(ItemUtil.customArmourMaterial("aoa3:primordial", 62, new int[]{5, 8, 9, 4}, 10, SoundEvents.field_187719_p, 7.0f), slot);
    }

    @Override
    public AdventArmour.Type setType() {
        return AdventArmour.Type.PRIMORDIAL;
    }

    @Override
    public void onAttackReceived(PlayerDataManager plData, @Nullable HashSet<EquipmentSlotType> slots, LivingHurtEvent event) {
        if ((slots == null || DamageUtil.isMeleeDamage(event.getSource()) && plData.equipment().getCurrentFullArmourSet() != this.setType()) && event.getSource().func_76346_g() instanceof LivingEntity && ((LivingEntity)event.getSource().func_76346_g()).func_70644_a(Effects.field_82731_v)) {
            event.setAmount(event.getAmount() * (1.0f - 0.15f * (float)(slots == null ? 4 : slots.size())));
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.primordial_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
        tooltip.add((ITextComponent)this.pieceEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.primordial_armour.desc.2", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
        tooltip.add((ITextComponent)this.setEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.primordial_armour.desc.3", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
    }
}

