/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.entity.minion.RosidEntity;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.player.PlayerDataManager;

public class RosidianArmour
extends AdventArmour {
    public RosidianArmour(EquipmentSlotType slot) {
        super(ItemUtil.customArmourMaterial("aoa3:rosidian", 55, new int[]{4, 7, 9, 4}, 10, SoundEvents.field_187719_p, 5.0f), slot);
    }

    @Override
    public AdventArmour.Type setType() {
        return AdventArmour.Type.ROSIDIAN;
    }

    @Override
    public void onPostAttackReceived(PlayerDataManager plData, @Nullable HashSet<EquipmentSlotType> slots, LivingDamageEvent event) {
        if (!DamageUtil.isEnvironmentalDamage(event.getSource()) && !DamageUtil.isPoisonDamage(event.getSource(), (Entity)plData.player(), event.getAmount())) {
            if (slots == null) {
                if (event.getAmount() >= 4.0f) {
                    this.spawnRosid((PlayerEntity)plData.player());
                }
            } else if ((double)field_77697_d.nextFloat() < 0.04 * (double)slots.size()) {
                this.spawnRosid((PlayerEntity)plData.player());
            }
        }
    }

    private void spawnRosid(PlayerEntity pl) {
        RosidEntity rosid = new RosidEntity((EntityType<? extends TameableEntity>)((EntityType)AoAEntities.Minions.ROSID.get()), pl.field_70170_p);
        rosid.func_193101_c(pl);
        rosid.func_70107_b(pl.func_226277_ct_(), pl.func_226278_cu_(), pl.func_226281_cx_());
        pl.field_70170_p.func_217376_c((Entity)rosid);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)this.pieceEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.rosidian_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
        tooltip.add((ITextComponent)this.setEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.rosidian_armour.desc.2", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
    }
}

