/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.player.PlayerDataManager;

public class SealordHelmet
extends AdventArmour {
    public static final AttributeModifier SEALORD_ATTACK_BUFF = new AttributeModifier(UUID.fromString("027744fa-e85d-4d1e-946a-747739900753"), "AoASealordMovementBuff", 2.0, AttributeModifier.Operation.ADDITION);

    public SealordHelmet() {
        super(ItemUtil.customArmourMaterial("aoa3:sealord", 60, new int[]{5, 7, 9, 5}, 10, SoundEvents.field_187719_p, 7.0f), EquipmentSlotType.HEAD);
    }

    @Override
    public AdventArmour.Type setType() {
        return AdventArmour.Type.ALL;
    }

    @Override
    public void onEffectTick(PlayerDataManager plData, @Nullable HashSet<EquipmentSlotType> slots) {
        ServerPlayerEntity player = plData.player();
        if (player.func_208600_a(FluidTags.field_206959_a)) {
            EntityUtil.applyAttributeModifierSafely((LivingEntity)plData.player(), SharedMonsterAttributes.field_188790_f, SEALORD_ATTACK_BUFF);
        } else {
            EntityUtil.removeAttributeModifier((LivingEntity)plData.player(), SharedMonsterAttributes.field_188790_f, SEALORD_ATTACK_BUFF);
        }
    }

    @Override
    public void onUnequip(PlayerDataManager plData, @Nullable EquipmentSlotType slot) {
        EntityUtil.removeAttributeModifier((LivingEntity)plData.player(), SharedMonsterAttributes.field_188790_f, SEALORD_ATTACK_BUFF);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new String[0]));
        tooltip.add((ITextComponent)this.anySetEffectHeader());
    }
}

