/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.item.weapon.gun.BaseGun;
import net.tslat.aoa3.item.weapon.sniper.BaseSniper;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.player.PlayerDataManager;

public class SharpshotArmour
extends AdventArmour {
    public SharpshotArmour(EquipmentSlotType slot) {
        super(ItemUtil.customArmourMaterial("aoa3:sharpshot", 54, new int[]{4, 6, 9, 5}, 10, SoundEvents.field_187719_p, 5.0f), slot);
    }

    @Override
    public AdventArmour.Type setType() {
        return AdventArmour.Type.SHARPSHOT;
    }

    @Override
    public void onDamageDealt(PlayerDataManager plData, @Nullable HashSet<EquipmentSlotType> slots, LivingHurtEvent event) {
        Item gun;
        if (DamageUtil.isGunDamage(event.getSource()) && ((gun = plData.player().func_184614_ca().func_77973_b()) instanceof BaseGun || (gun = plData.player().func_184592_cb().func_77973_b()) instanceof BaseGun)) {
            if (slots == null) {
                if (gun instanceof BaseSniper) {
                    event.setAmount(event.getAmount() * 1.1f);
                }
            } else {
                event.setAmount(event.getAmount() * (1.0f + 0.07f * (float)slots.size()));
            }
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)this.pieceEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.sharpshot_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
        tooltip.add((ITextComponent)this.setEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.sharpshot_armour.desc.2", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
    }
}

