/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.player.PlayerDataManager;

public class SpeedArmour
extends AdventArmour {
    private static final AttributeModifier SET_BONUS = new AttributeModifier(UUID.fromString("748347d0-6ed4-4917-9495-0e7137fcf61a"), "AoASpeedArmourBoots", 0.1, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private static final AttributeModifier BOOTS_BONUS = new AttributeModifier(UUID.fromString("d0a8b22e-8c0e-42a0-be57-284110170f8c"), "AoASpeedArmourBoots", 0.1, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private static final AttributeModifier LEGS_BONUS = new AttributeModifier(UUID.fromString("31c9600f-b10f-48f0-8acb-2a3009fb3466"), "AoASpeedArmourLegs", 0.1, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private static final AttributeModifier CHESTPLATE_BONUS = new AttributeModifier(UUID.fromString("0f20e0f4-a909-409d-99cf-65fd80f516c7"), "AoASpeedArmourBody", 0.1, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private static final AttributeModifier HELMET_BONUS = new AttributeModifier(UUID.fromString("6d13cd91-39d8-4e68-8c25-b9b45bb729d9"), "AoASpeedArmourHelmet", 0.1, AttributeModifier.Operation.MULTIPLY_TOTAL);

    public SpeedArmour(EquipmentSlotType slot) {
        super(ItemUtil.customArmourMaterial("aoa3:speed", 63, new int[]{4, 9, 9, 3}, 10, SoundEvents.field_187719_p, 7.0f), slot);
    }

    @Override
    public AdventArmour.Type setType() {
        return AdventArmour.Type.SPEED;
    }

    @Override
    public void onEquip(PlayerDataManager plData, @Nullable EquipmentSlotType slot) {
        if (slot == null) {
            EntityUtil.applyAttributeModifierSafely((LivingEntity)plData.player(), SharedMonsterAttributes.field_111263_d, SET_BONUS);
        } else {
            switch (slot) {
                case FEET: {
                    EntityUtil.applyAttributeModifierSafely((LivingEntity)plData.player(), SharedMonsterAttributes.field_111263_d, BOOTS_BONUS);
                    break;
                }
                case LEGS: {
                    EntityUtil.applyAttributeModifierSafely((LivingEntity)plData.player(), SharedMonsterAttributes.field_111263_d, LEGS_BONUS);
                    break;
                }
                case CHEST: {
                    EntityUtil.applyAttributeModifierSafely((LivingEntity)plData.player(), SharedMonsterAttributes.field_111263_d, CHESTPLATE_BONUS);
                    break;
                }
                case HEAD: {
                    EntityUtil.applyAttributeModifierSafely((LivingEntity)plData.player(), SharedMonsterAttributes.field_111263_d, HELMET_BONUS);
                    break;
                }
            }
        }
    }

    @Override
    public void onUnequip(PlayerDataManager plData, @Nullable EquipmentSlotType slot) {
        if (slot == null) {
            EntityUtil.removeAttributeModifier((LivingEntity)plData.player(), SharedMonsterAttributes.field_111263_d, SET_BONUS);
        } else {
            switch (slot) {
                case FEET: {
                    EntityUtil.removeAttributeModifier((LivingEntity)plData.player(), SharedMonsterAttributes.field_111263_d, BOOTS_BONUS);
                    break;
                }
                case LEGS: {
                    EntityUtil.removeAttributeModifier((LivingEntity)plData.player(), SharedMonsterAttributes.field_111263_d, LEGS_BONUS);
                    break;
                }
                case CHEST: {
                    EntityUtil.removeAttributeModifier((LivingEntity)plData.player(), SharedMonsterAttributes.field_111263_d, CHESTPLATE_BONUS);
                    break;
                }
                case HEAD: {
                    EntityUtil.removeAttributeModifier((LivingEntity)plData.player(), SharedMonsterAttributes.field_111263_d, HELMET_BONUS);
                    break;
                }
            }
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)this.pieceEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.speed_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
        tooltip.add((ITextComponent)this.setEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.speed_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
    }
}

