/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.player.PlayerDataManager;

public class SubterraneanArmour
extends AdventArmour {
    private static final AttributeModifier ATTACK_SPEED_DEBUFF = new AttributeModifier(UUID.fromString("d4631555-8ceb-490d-9066-fb4188560b15"), "AoASubterraneanAttackSpeedDebuff", -0.16666667, AttributeModifier.Operation.MULTIPLY_TOTAL);

    public SubterraneanArmour(EquipmentSlotType slot) {
        super(ItemUtil.customArmourMaterial("aoa3:subterranean", 47, new int[]{3, 7, 8, 4}, 10, SoundEvents.field_187719_p, 3.0f), slot);
    }

    @Override
    public AdventArmour.Type setType() {
        return AdventArmour.Type.SUBTERRANEAN;
    }

    @Override
    public void onEquip(PlayerDataManager plData, @Nullable EquipmentSlotType slot) {
        if (slot == null) {
            EntityUtil.applyAttributeModifierSafely((LivingEntity)plData.player(), SharedMonsterAttributes.field_188790_f, ATTACK_SPEED_DEBUFF);
        }
    }

    @Override
    public void onUnequip(PlayerDataManager plData, @Nullable EquipmentSlotType slot) {
        if (slot == null) {
            EntityUtil.removeAttributeModifier((LivingEntity)plData.player(), SharedMonsterAttributes.field_188790_f, ATTACK_SPEED_DEBUFF);
        }
    }

    @Override
    public void onEffectTick(PlayerDataManager plData, @Nullable HashSet<EquipmentSlotType> slots) {
        if (slots == null) {
            plData.player().func_195064_c(new EffectInstance(Effects.field_76422_e, -1, 1, true, false));
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)this.setEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.subterranean_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
    }
}

