/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.player.PlayerDataManager;

public class VoidArmour
extends AdventArmour {
    public VoidArmour(EquipmentSlotType slot) {
        super(ItemUtil.customArmourMaterial("aoa3:void", 25, new int[]{3, 6, 8, 3}, 10, SoundEvents.field_187719_p, 2.0f), slot);
    }

    @Override
    public AdventArmour.Type setType() {
        return AdventArmour.Type.VOID;
    }

    @Override
    public void onPostAttackReceived(PlayerDataManager plData, @Nullable HashSet<EquipmentSlotType> slots, LivingDamageEvent event) {
        if ((slots == null || plData.equipment().getCurrentFullArmourSet() != this.setType()) && !plData.player().field_70170_p.field_72995_K && event.getSource().func_76346_g() instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)event.getSource().func_76346_g();
            if (DamageUtil.isMeleeDamage(event.getSource())) {
                if (slots == null) {
                    if (RandomUtil.oneInNChance(5)) {
                        attacker.func_195064_c(new EffectInstance(Effects.field_76421_d, 30, 20, true, true));
                    }
                } else if (field_77697_d.nextFloat() < 0.025f * (float)slots.size()) {
                    attacker.func_195064_c(new EffectInstance(Effects.field_76421_d, 30, 20, true, true));
                }
            }
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)this.pieceEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.void_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
        tooltip.add((ITextComponent)this.setEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.void_armour.desc.2", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
    }
}

