/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.minionslab;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.entity.minion.AoAMinion;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PotionUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.constant.Resources;
import net.tslat.aoa3.util.constant.Skills;
import net.tslat.aoa3.util.player.PlayerDataManager;
import net.tslat.aoa3.util.player.PlayerUtil;

public abstract class BaseSlab
extends Item {
    public final int lvl;
    public final float cost;
    public final int sacrificeLvl;
    public final float sacrificeXp;

    public BaseSlab(int lvl, float creationCost, int sacrificeLvl, float sacrificeXp) {
        super(new Item.Properties().func_200916_a(AoAItemGroups.MINION_SLABS));
        this.lvl = lvl;
        this.cost = creationCost;
        this.sacrificeLvl = sacrificeLvl;
        this.sacrificeXp = sacrificeXp;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player instanceof ServerPlayerEntity) {
            ServerPlayerEntity pl = (ServerPlayerEntity)player;
            PlayerDataManager plData = PlayerUtil.getAdventPlayer(pl);
            if (!player.func_184812_l_() && !PlayerUtil.doesPlayerHaveLevel(pl, Skills.CREATION, this.lvl)) {
                PlayerUtil.notifyPlayerOfInsufficientLevel(pl, Skills.CREATION, this.lvl);
                return ActionResult.func_226251_d_((Object)stack);
            }
            if (world.func_175647_a(AoAMinion.class, player.func_174813_aQ().func_186662_g(30.0), minion -> minion != null && player.func_110124_au().equals(minion.func_184753_b())).size() >= (Integer)AoAConfig.SERVER.maxMinions.get()) {
                player.func_145747_a((ITextComponent)LocaleUtil.getLocaleMessage("message.feedback.minionSlab.maxMinions", String.valueOf(AoAConfig.SERVER.maxMinions.get())));
                return ActionResult.func_226251_d_((Object)stack);
            }
            if (player.func_184812_l_() || plData.stats().consumeResource(Resources.CREATION, this.cost, false)) {
                AoAMinion minion2;
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                if ((minion2 = this.activateSlab(player, stack)) != null && plData.equipment().getCurrentFullArmourSet() == AdventArmour.Type.CREATION) {
                    this.applyBuffs(minion2);
                }
                player.func_184185_a((SoundEvent)AoASounds.ITEM_CREATION_SLAB_USE.get(), 1.0f, 1.0f);
                return ActionResult.func_226248_a_((Object)stack);
            }
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public abstract AoAMinion activateSlab(PlayerEntity var1, ItemStack var2);

    protected void applyBuffs(AoAMinion minion) {
        EntityUtil.applyPotions((Entity)minion, RandomUtil.getRandomSelection(new PotionUtil.EffectBuilder(Effects.field_76424_c, 1200).level(2).hideParticles().isAmbient(), new PotionUtil.EffectBuilder(Effects.field_76420_g, 1200).level(2).hideParticles().isAmbient(), new PotionUtil.EffectBuilder(Effects.field_76428_l, 1200).level(2).hideParticles().isAmbient(), new PotionUtil.EffectBuilder(Effects.field_76429_m, 1200).level(2).hideParticles().isAmbient()));
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.slab.cost", LocaleUtil.ItemDescriptionType.ITEM_AMMO_COST, Integer.toString((int)this.cost)));
        tooltip.add(LocaleUtil.getFormattedLevelRestrictedDescriptionText(Skills.CREATION, this.lvl));
    }
}

