/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.misc;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.HuskEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.DistExecutor;
import net.tslat.aoa3.capabilities.volatilestack.VolatileStackCapabilityHandles;
import net.tslat.aoa3.capabilities.volatilestack.VolatileStackCapabilityProvider;
import net.tslat.aoa3.common.registration.AoADimensions;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.entity.base.AoATrader;
import net.tslat.aoa3.entity.mob.precasia.PrimitiveCarrotopEntity;
import net.tslat.aoa3.util.ClientOperations;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public class BlankRealmstone
extends Item {
    public BlankRealmstone() {
        super(new Item.Properties().func_200916_a(AoAItemGroups.MISC_ITEMS).func_200917_a(1));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (world.field_72995_K) {
            DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientOperations::displayBlankRealmstoneGui);
        }
        return ActionResult.func_226248_a_((Object)player.func_184586_b(hand));
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        BlockPos pos;
        BlockState state;
        if (!entity.field_70170_p.field_72995_K && entity.field_70170_p.func_201675_m().func_186058_p() == AoADimensions.PRECASIA.type() && (state = entity.field_70170_p.func_180495_p(pos = entity.func_180425_c())).func_177230_c() == Blocks.field_150459_bM && ((CropsBlock)state.func_177230_c()).func_185525_y(state)) {
            PrimitiveCarrotopEntity carrotop = new PrimitiveCarrotopEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.PRIMITIVE_CARROTOP.get()), entity.field_70170_p);
            carrotop.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.2, (double)pos.func_177952_p() + 0.5);
            entity.field_70170_p.func_217376_c((Entity)carrotop);
            entity.func_70106_y();
            entity.field_70170_p.func_175656_a(entity.func_180425_c(), Blocks.field_150350_a.func_176223_P());
        }
        return false;
    }

    public boolean func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        if (player.field_70170_p.func_201675_m().func_186058_p() == AoADimensions.CREEPONIA.type() && target instanceof AoATrader) {
            if (player instanceof ServerPlayerEntity && DamageUtil.isPlayerEnvironmentallyProtected((ServerPlayerEntity)player) && player.func_184586_b(hand).func_77973_b() == AoAItems.BLANK_REALMSTONE.get()) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
                ItemUtil.givePlayerItemOrDrop(player, new ItemStack((IItemProvider)AoAItems.VOX_PONDS_REALMSTONE.get()));
                PlayerUtil.notifyPlayer((ServerPlayerEntity)player, "message.dialogue.creeponiaBlankRealmstone." + RandomUtil.randomNumberUpTo(3), new Object[0]);
            }
            return true;
        }
        return false;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.field_70170_p.field_72995_K && target.func_110143_aJ() <= 0.0f && target instanceof HuskEntity && attacker instanceof PlayerEntity) {
            attacker.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)AoAItems.BARATHOS_REALMSTONE.get()));
        }
        return super.func_77644_a(stack, target, attacker);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new VolatileStackCapabilityProvider();
    }

    public static void handleAncientCavernTask(ItemStack stack, LivingEntity construct, PlayerEntity player) {
        VolatileStackCapabilityHandles cap = VolatileStackCapabilityProvider.getOrDefault(stack, null);
        long currentWorldTime = construct.field_70170_p.func_82737_E();
        HashMap constructKillMap = cap.getObject() == null ? new HashMap(5) : (HashMap)cap.getObject();
        constructKillMap.entrySet().removeIf(entry -> (Long)entry.getValue() < currentWorldTime - 600L);
        constructKillMap.put(construct.getClass(), currentWorldTime);
        if (constructKillMap.size() >= 5) {
            stack.func_190918_g(1);
            ItemUtil.givePlayerItemOrDrop(player, new ItemStack((IItemProvider)AoAItems.ANCIENT_CAVERN_REALMSTONE.get()));
        } else {
            cap.setObject(constructKillMap);
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.NEUTRAL, 1, new String[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.NEUTRAL, 2, new String[0]));
    }
}

