/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.misc;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CocoaBlock;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SaplingBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.util.constant.Skills;
import net.tslat.aoa3.util.player.PlayerDataManager;
import net.tslat.aoa3.util.player.PlayerUtil;
import net.tslat.aoa3.util.skill.AnimaUtil;

public class FragmentedAnimaStone
extends Item {
    public FragmentedAnimaStone() {
        super(new Item.Properties().func_200916_a(AoAItemGroups.MISC_ITEMS));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        int bonemealEvent;
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        ItemStack stack = context.func_195996_i();
        if (player != null && !player.func_175151_a(pos.func_177972_a(context.func_196000_l()), context.func_196000_l(), stack)) {
            return ActionResultType.FAIL;
        }
        BlockState state = world.func_180495_p(pos);
        if (player != null && (bonemealEvent = ForgeEventFactory.onApplyBonemeal((PlayerEntity)player, (World)world, (BlockPos)pos, (BlockState)state, (ItemStack)stack)) != 0) {
            return bonemealEvent > 0 ? ActionResultType.PASS : ActionResultType.FAIL;
        }
        if (state.func_177230_c() instanceof IGrowable) {
            IGrowable growable = (IGrowable)state.func_177230_c();
            if (growable.func_176473_a((IBlockReader)world, pos, state, world.field_72995_K) && world instanceof ServerWorld) {
                PlayerDataManager.PlayerStats plStats = PlayerUtil.getAdventPlayer((ServerPlayerEntity)player).stats();
                Block block = state.func_177230_c();
                if (block instanceof SaplingBlock) {
                    for (int backupCounter = 10; world.func_180495_p(pos).func_177230_c() == state.func_177230_c() && backupCounter > 0; --backupCounter) {
                        ((SaplingBlock)block).func_226942_a_((ServerWorld)world, pos, world.func_180495_p(pos), world.func_201674_k());
                    }
                } else if (block instanceof CropsBlock) {
                    world.func_180501_a(pos, ((CropsBlock)block).func_185528_e(((CropsBlock)block).func_185526_g()), 2);
                } else if (block instanceof CocoaBlock) {
                    world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)CocoaBlock.field_176501_a, (Comparable)Integer.valueOf(2)), 2);
                } else {
                    int backupCounter;
                    int n = backupCounter = block instanceof GrassBlock ? 1 : 10;
                    while (world.func_180495_p(pos).equals(state) && backupCounter > 0) {
                        --backupCounter;
                        growable.func_225535_a_((ServerWorld)world, world.field_73012_v, pos, state);
                    }
                }
                plStats.addXp(Skills.ANIMA, PlayerUtil.getXpRequiredForNextLevel(plStats.getLevel(Skills.ANIMA)) / (float)AnimaUtil.getExpDenominator(plStats.getLevel(Skills.ANIMA)), false, false);
                world.func_217379_c(2005, pos, 0);
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }
}

