/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.misc;

import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.entity.misc.LottoTotemEntity;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public class LottoTotem
extends Item {
    public LottoTotem() {
        super(new Item.Properties().func_200916_a(AoAItemGroups.MISC_ITEMS));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.FAIL;
        }
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState targetBlockState = world.func_180495_p(pos);
        if (context.func_196000_l() != Direction.UP || !targetBlockState.func_224755_d((IBlockReader)world, pos, Direction.UP)) {
            return ActionResultType.FAIL;
        }
        if (!world.field_72995_K) {
            if (!world.func_217357_a(LottoTotemEntity.class, new AxisAlignedBB(pos).func_186662_g(4.0)).isEmpty()) {
                PlayerUtil.notifyPlayer((ServerPlayerEntity)player, "message.feedback.lottoTotem.nearby", TextFormatting.RED);
                return ActionResultType.FAIL;
            }
            ArrayList<BlockPos> spawnPositions = new ArrayList<BlockPos>(5);
            spawnPositions.add(pos);
            if (this.populateSpawnPositions(world, pos, spawnPositions)) {
                player.func_184586_b(context.func_221531_n()).func_190918_g(1);
                int selectedWinner = RandomUtil.randomNumberUpTo(5);
                UUID winningUUID = MathHelper.func_188210_a();
                for (BlockPos spawnPos : spawnPositions) {
                    LottoTotemEntity totem = new LottoTotemEntity(world, spawnPos, winningUUID, player.func_110124_au());
                    if (selectedWinner == 0) {
                        totem.func_184221_a(winningUUID);
                    }
                    world.func_217376_c((Entity)totem);
                    --selectedWinner;
                }
                PlayerUtil.notifyPlayer((ServerPlayerEntity)player, "message.feedback.lottoTotem.spawn", TextFormatting.GOLD);
            } else {
                PlayerUtil.notifyPlayer((ServerPlayerEntity)player, "message.feedback.lottoTotem.noSpace", TextFormatting.RED);
                return ActionResultType.FAIL;
            }
        }
        return ActionResultType.PASS;
    }

    private boolean populateSpawnPositions(World world, BlockPos pos, ArrayList<BlockPos> spawnPositions) {
        BlockPos.Mutable checkPos = new BlockPos.Mutable(pos);
        for (int x = pos.func_177958_n() - 1; x <= pos.func_177958_n() + 1; x += 2) {
            for (int z = pos.func_177952_p() - 1; z <= pos.func_177952_p() + 1; z += 2) {
                checkPos.func_181079_c(x, pos.func_177956_o(), z);
                if (!world.func_180495_p(checkPos.func_177984_a()).func_185904_a().func_76222_j() || !world.func_180495_p((BlockPos)checkPos).func_224755_d((IBlockReader)world, (BlockPos)checkPos, Direction.UP)) continue;
                spawnPositions.add(checkPos.func_185334_h());
                if (spawnPositions.size() < 5) continue;
                return true;
            }
        }
        return false;
    }
}

