/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.misc;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoAWeapons;
import net.tslat.aoa3.entity.mob.shyrelands.ArcwormEntity;
import net.tslat.aoa3.item.weapon.blaster.ExperimentW801;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PotionUtil;

public class ReservedItem
extends Item {
    private final String sequenceId;

    public ReservedItem(String sequenceName) {
        super(new Item.Properties().func_208103_a(Rarity.EPIC));
        this.sequenceId = sequenceName;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!this.verifyStack(stack)) {
            stack.func_190920_e(0);
            entityIn.func_174820_d(itemSlot, ItemStack.field_190927_a);
        }
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        if (context.func_195999_j() == null) {
            return super.onItemUseFirst(stack, context);
        }
        Block block = context.func_195991_k().func_180495_p(context.func_195995_a()).func_177230_c();
        if (block == AoABlocks.CHARGING_TABLE.get()) {
            if (this == AoAItems.FLESHY_BONES.get()) {
                context.func_195999_j().func_184611_a(context.func_221531_n(), ((ReservedItem)AoAItems.DARK_BONES.get()).newValidStack());
                return ActionResultType.SUCCESS;
            }
        } else if (block == AoABlocks.MINERALIZATION_STATION.get() && this == AoAItems.DARK_BONES.get()) {
            context.func_195999_j().func_184611_a(context.func_221531_n(), ((ReservedItem)AoAItems.ROCK_BONES.get()).newValidStack());
            return ActionResultType.SUCCESS;
        }
        return super.onItemUseFirst(stack, context);
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!target.field_70170_p.field_72995_K) {
            if (stack.func_77973_b() == AoAItems.MILLENNIUM_UPGRADER.get()) {
                if (target.func_180799_ab() && attacker.func_180799_ab()) {
                    attacker.func_184611_a(Hand.MAIN_HAND, ((ReservedItem)AoAItems.MOLTEN_UPGRADER.get()).newValidStack());
                    return true;
                }
            } else if (stack.func_77973_b() == AoAItems.MOLTEN_UPGRADER.get()) {
                if (target.field_70170_p.func_130001_d() == 1.0f && target.func_110143_aJ() <= 0.0f && (target.func_200600_R() == AoAEntities.Mobs.DARK_BEAST.get() || target.func_200600_R() == AoAEntities.Mobs.IRKLING.get() || target.func_200600_R() == AoAEntities.Mobs.NIGHT_WATCHER.get() || target.func_200600_R() == AoAEntities.Mobs.SCRUBBY.get() || target.func_200600_R() == AoAEntities.Mobs.SKELLOX.get())) {
                    attacker.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                    target.func_70099_a(((ReservedItem)AoAItems.MOONSTONE.get()).newValidStack(), 0.0f);
                    return true;
                }
            } else if (stack.func_77973_b() == AoAItems.MOONSTONE.get()) {
                if (target instanceof ArcwormEntity) {
                    EntityUtil.applyPotions((Entity)target, new PotionUtil.EffectBuilder(Effects.field_188424_y, 200).level(11).hideParticles());
                }
                return true;
            }
        }
        return false;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (!this.verifyStack(entity.func_92059_d())) {
            entity.func_92058_a(ItemStack.field_190927_a);
            entity.func_70106_y();
        }
        return false;
    }

    public ItemStack newValidStack() {
        ItemStack stack = new ItemStack((IItemProvider)this);
        CompoundNBT tag = new CompoundNBT();
        tag.func_74757_a(this.sequenceId, true);
        stack.func_77982_d(tag);
        return stack;
    }

    private boolean verifyStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (!stack.func_77942_o()) {
            return false;
        }
        CompoundNBT tag = stack.func_77978_p();
        if (!tag.func_74764_b(this.sequenceId)) {
            return false;
        }
        return tag.func_74767_n(this.sequenceId);
    }

    public static void handleArcworm(ArcwormEntity arcworm) {
        if (arcworm.func_226278_cu_() > 275.0 && arcworm.func_94060_bK() instanceof PlayerEntity && arcworm.func_94060_bK().func_184614_ca().func_77973_b() == AoAItems.MOONSTONE.get()) {
            arcworm.func_70099_a(((ExperimentW801)AoAWeapons.EXPERIMENT_W_801.get()).newValidStack(), 0.0f);
            arcworm.func_94060_bK().func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
            arcworm.func_70106_y();
        }
    }

    public static void handlePlayerDeath(PlayerEntity pl) {
        if (pl.func_110143_aJ() > 0.0f && !pl.field_70170_p.func_72912_H().func_76093_s()) {
            return;
        }
        if (!pl.func_184614_ca().func_77973_b().getRegistryName().func_110623_a().toLowerCase(Locale.ENGLISH).startsWith("a")) {
            return;
        }
        NonNullList armour = pl.field_71071_by.field_70460_b;
        if (!((ItemStack)armour.get(3)).func_77973_b().getRegistryName().func_110623_a().toLowerCase(Locale.ENGLISH).startsWith("l")) {
            return;
        }
        if (!((ItemStack)armour.get(2)).func_77973_b().getRegistryName().func_110623_a().toLowerCase(Locale.ENGLISH).startsWith("i")) {
            return;
        }
        if (!((ItemStack)armour.get(1)).func_77973_b().getRegistryName().func_110623_a().toLowerCase(Locale.ENGLISH).startsWith("e")) {
            return;
        }
        if (!((ItemStack)armour.get(0)).func_77973_b().getRegistryName().func_110623_a().toLowerCase(Locale.ENGLISH).startsWith("n")) {
            return;
        }
        if (ItemUtil.findInventoryItem(pl, new ItemStack((IItemProvider)AoAItems.ALIEN_ORB.get()), false, 1)) {
            return;
        }
        pl.func_70099_a(((ReservedItem)AoAItems.ALIEN_ORB.get()).newValidStack(), 0.0f);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77973_b() == AoAItems.ALIEN_ORB.get()) {
            tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.UNIQUE, 1, new String[0]));
        }
    }
}

