/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.misc;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.constant.Skills;
import net.tslat.aoa3.util.player.PlayerDataManager;
import net.tslat.aoa3.util.player.PlayerUtil;

public class SkillCrystal
extends Item {
    private final float denominator;
    private final int lowerLimit = 15;

    public SkillCrystal(float denominator) {
        super(new Item.Properties().func_200916_a(AoAItemGroups.MISC_ITEMS));
        this.denominator = denominator;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (player instanceof ServerPlayerEntity) {
            PlayerDataManager plData = PlayerUtil.getAdventPlayer((ServerPlayerEntity)player);
            Skills skill = PlayerUtil.getLowestSkillWithLimit(plData, 15);
            if (skill != null) {
                plData.stats().addXp(skill, PlayerUtil.getXpRequiredForNextLevel(plData.stats().getLevel(skill)) / this.denominator, false, true);
                if (!player.func_184812_l_()) {
                    heldStack.func_190918_g(1);
                }
            } else {
                plData.sendThrottledChatMessage("message.feedback.item.skillCrystal.levelFail", Integer.toString(15));
            }
        }
        return ActionResult.func_226250_c_((Object)heldStack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.skillCrystal.desc.1", LocaleUtil.ItemDescriptionType.NEUTRAL, new String[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.skillCrystal.desc.2", LocaleUtil.ItemDescriptionType.NEUTRAL, Integer.toString(15)));
    }
}

