/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.misc;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.WrittenBookItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.library.resourcemanager.MiscTextFileManager;
import net.tslat.aoa3.util.ClientOperations;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class WornBook
extends WrittenBookItem {
    private static final CompoundNBT contents = new CompoundNBT();

    public WornBook() {
        super(new Item.Properties().func_200916_a(AoAItemGroups.MISC_ITEMS).func_200917_a(1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ItemStack getBook(ItemStack stack) {
        stack.func_77982_d(WornBook.getBookContents());
        return stack;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack bookStack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (!ItemUtil.findInventoryItem(player, new ItemStack((IItemProvider)AoAItems.BLANK_REALMSTONE.get()), false, 1)) {
                ItemUtil.givePlayerItemOrDrop(player, new ItemStack((IItemProvider)AoAItems.BLANK_REALMSTONE.get()));
                player.func_145747_a((ITextComponent)LocaleUtil.getLocaleMessage("message.feedback.wornBook.droppedRealmstone"));
            }
        } else {
            DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientOperations::displayWornBookGui);
        }
        return ActionResult.func_226248_a_((Object)bookStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static CompoundNBT getBookContents() {
        contents.func_74778_a("author", LocaleUtil.getLocaleString("entity.aoa3.corrupted_traveller"));
        contents.func_74778_a("title", LocaleUtil.getLocaleString("item.aoa3.worn_book"));
        String pageContents = MiscTextFileManager.DATA.get(AoAItems.WORN_BOOK.get());
        if (pageContents == null) {
            return contents;
        }
        String[] lines = pageContents.split("\n");
        ListNBT pages = new ListNBT();
        for (String line : lines) {
            pages.add((Object)StringNBT.func_229705_a_((String)line.replaceAll("<br>", "\n")));
        }
        contents.func_218657_a("pages", (INBT)pages);
        return contents;
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }
}

