/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.misc.summoning;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.entity.boss.CorallusEntity;
import net.tslat.aoa3.item.misc.summoning.BossSpawningItem;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public class AmphibiyteLung
extends BossSpawningItem {
    public AmphibiyteLung() {
        super(() -> null, new IParticleData[]{ParticleTypes.field_197612_e});
    }

    @Override
    public void handleTimerParticles(ItemEntity entityItem, double posX, double posY, double posZ, int lifespan, int ticksExisted) {
        if (entityItem.func_70090_H() && entityItem.func_92059_d().func_190916_E() == 5) {
            super.handleTimerParticles(entityItem, posX, posY, posZ, lifespan, ticksExisted);
        } else if (entityItem.func_92059_d().func_190916_E() != 5 || entityItem.field_70173_aa > 40 && lifespan != 200) {
            entityItem.lifespan = 6000;
        }
    }

    @Override
    public void spawnBoss(World world, ServerPlayerEntity summoner, double posX, double posY, double posZ) {
        CorallusEntity corallus = new CorallusEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.CORALLUS.get()), world);
        corallus.func_70012_b(posX, posY, posZ, RandomUtil.randomValueUpTo(360.0f), 0.0f);
        world.func_217376_c((Entity)corallus);
        PlayerUtil.messageAllPlayersInRange((ITextComponent)LocaleUtil.getLocaleMessage("entity.aoa3.corallus.spawn", summoner.func_145748_c_().func_150254_d()), world, new BlockPos(posX, posY, posZ), 50);
    }

    @Override
    public boolean canSpawnHere(World world, ServerPlayerEntity player, double posX, double posY, double posZ) {
        if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != Blocks.field_150355_j) {
            return false;
        }
        if (!this.checkSpawnArea(world, new AxisAlignedBB(posX - 0.5, posY, posZ - 0.5, posX + 0.5, posY + 3.0, posZ + 0.5))) {
            PlayerUtil.notifyPlayer(player, "message.feedback.spawnBoss.noSpace", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean checkSpawnArea(World world, AxisAlignedBB boundingBox) {
        try (BlockPos.PooledMutable checkPos = BlockPos.PooledMutable.func_185346_s();){
            for (int x = MathHelper.func_76128_c((double)boundingBox.field_72340_a); x < MathHelper.func_76143_f((double)boundingBox.field_72336_d); ++x) {
                for (int y = MathHelper.func_76128_c((double)boundingBox.field_72338_b); y < MathHelper.func_76143_f((double)boundingBox.field_72337_e); ++y) {
                    for (int z = MathHelper.func_76128_c((double)boundingBox.field_72339_c); z < MathHelper.func_76143_f((double)boundingBox.field_72334_f); ++z) {
                        BlockState state = world.func_180495_p((BlockPos)checkPos.func_181079_c(x, y, z));
                        if (state.isAir((IBlockReader)world, (BlockPos)checkPos) || state.func_204520_s().func_206886_c() != Fluids.field_204541_a) continue;
                        boolean bl = false;
                        return bl;
                    }
                }
            }
            boolean bl = true;
            return bl;
        }
    }
}

