/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.misc.summoning;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoADimensions;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.boss.TyrosaurEntity;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public class BoneHorn
extends Item {
    public BoneHorn() {
        super(new Item.Properties().func_200916_a(AoAItemGroups.MISC_ITEMS).func_200918_c(3));
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 60;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (world.func_175659_aa() != Difficulty.PEACEFUL) {
            if (!world.field_72995_K) {
                player.func_184185_a((SoundEvent)AoASounds.ITEM_BONE_HORN_CALL.get(), 1.0f, 1.0f);
            }
            player.func_184598_c(hand);
            player.func_184811_cZ().func_185145_a((Item)this, 150);
            return ActionResult.func_226248_a_((Object)heldItem);
        }
        if (player instanceof ServerPlayerEntity) {
            PlayerUtil.notifyPlayer((ServerPlayerEntity)player, "message.feedback.spawnBoss.difficultyFail", TextFormatting.RED);
        }
        return ActionResult.func_226251_d_((Object)heldItem);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity user) {
        if (!world.field_72995_K && world.func_201675_m().func_186058_p() == AoADimensions.PRECASIA.type()) {
            int tries;
            TyrosaurEntity tyrosaur = new TyrosaurEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.TYROSAUR.get()), world);
            BlockPos spawnPos = RandomUtil.getRandomPositionWithinRange(user.func_180425_c(), 20, 10, 20, true, world);
            for (tries = 10; (double)spawnPos.func_177956_o() > user.func_226278_cu_() + 10.0 && tries > 0; --tries) {
                spawnPos = RandomUtil.getRandomPositionWithinRange(user.func_180425_c(), 20, 10, 20, true, world);
            }
            if (tries == 0) {
                return stack;
            }
            tyrosaur.func_70107_b(spawnPos.func_177958_n(), spawnPos.func_177956_o(), spawnPos.func_177952_p());
            tyrosaur.func_70624_b(user);
            world.func_217376_c((Entity)tyrosaur);
            ItemUtil.damageItem(stack, user, user.func_184600_cs());
            PlayerUtil.messageAllPlayersInRange((ITextComponent)LocaleUtil.getLocaleMessage("entity.aoa3.tyrosaur.spawn", user.func_145748_c_().func_150254_d()), world, user.func_180425_c(), 50);
        }
        return stack;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.NEUTRAL, 1, new String[0]));
    }
}

