/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.misc.summoning;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.entity.misc.BossItemEntity;
import net.tslat.aoa3.util.RandomUtil;

public abstract class BossSpawningItem
extends Item {
    private final IParticleData[] timerParticles;
    private final Supplier<SoundEvent> throwingSound;

    public BossSpawningItem(@Nullable Supplier<SoundEvent> throwSound, IParticleData ... timerParticles) {
        super(new Item.Properties().func_200916_a(AoAItemGroups.MISC_ITEMS));
        this.timerParticles = timerParticles;
        this.throwingSound = throwSound;
    }

    public void handleTimerParticles(ItemEntity entityItem, double posX, double posY, double posZ, int lifespan, int ticksExisted) {
        int index = (int)((float)ticksExisted / (float)lifespan * (float)this.timerParticles.length);
        if (RandomUtil.oneInNChance(1 + (lifespan - ticksExisted) / 20)) {
            entityItem.field_70170_p.func_195594_a(this.timerParticles[index], posX, posY + 0.25, posZ, 0.0, 0.0, 0.0);
        }
    }

    public abstract void spawnBoss(World var1, ServerPlayerEntity var2, double var3, double var5, double var7);

    public abstract boolean canSpawnHere(World var1, ServerPlayerEntity var2, double var3, double var5, double var7);

    @Nullable
    public SoundEvent getThrowingSound() {
        return this.throwingSound.get();
    }

    public static BossItemEntity newBossEntityItemFromExisting(ItemEntity item, PlayerEntity player) {
        BossItemEntity bossItem = new BossItemEntity(item.field_70170_p, item.func_226277_ct_(), item.func_226278_cu_(), item.func_226281_cx_(), item.func_92059_d(), player);
        bossItem.func_174867_a(10);
        bossItem.func_200216_c(player.func_110124_au());
        bossItem.func_200217_b(player.func_110124_au());
        bossItem.func_213317_d(item.func_213322_ci());
        return bossItem;
    }
}

