/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.misc.summoning;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.boss.KingBambambamEntity;
import net.tslat.aoa3.item.misc.summoning.BossSpawningItem;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public class ExplosiveIdol
extends BossSpawningItem {
    public ExplosiveIdol() {
        super((Supplier<SoundEvent>)AoASounds.ENTITY_KING_BAMBAMBAM_AMBIENT, new IParticleData[]{ParticleTypes.field_197601_L, ParticleTypes.field_197594_E, ParticleTypes.field_197627_t});
    }

    @Override
    public void spawnBoss(World world, ServerPlayerEntity summoner, double posX, double posY, double posZ) {
        KingBambambamEntity kingBamBamBam = new KingBambambamEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.KING_BAMBAMBAM.get()), world);
        kingBamBamBam.func_70012_b(posX, posY, posZ, RandomUtil.randomValueUpTo(360.0f), 0.0f);
        world.func_217376_c((Entity)kingBamBamBam);
        PlayerUtil.messageAllPlayersInRange((ITextComponent)LocaleUtil.getLocaleMessage("entity.aoa3.king_bambambam.spawn", summoner.func_145748_c_().func_150254_d()), world, new BlockPos(posX, posY, posZ), 50);
    }

    @Override
    public boolean canSpawnHere(World world, ServerPlayerEntity player, double posX, double posY, double posZ) {
        if (world.func_175659_aa() == Difficulty.PEACEFUL) {
            PlayerUtil.notifyPlayer(player, "message.feedback.spawnBoss.difficultyFail", TextFormatting.RED);
            return false;
        }
        if (world.func_201675_m().func_186058_p() != DimensionType.field_223228_b_) {
            PlayerUtil.notifyPlayer(player, "entity.aoa3.king_bambambam.wrongDimension", TextFormatting.RED);
            return false;
        }
        if (world.func_72829_c(new AxisAlignedBB(posX - 1.0, posY, posZ - 1.0, posX + 1.0, posY + 4.0, posZ + 1.0))) {
            PlayerUtil.notifyPlayer(player, "message.feedback.spawnBoss.noSpace", TextFormatting.RED);
            return false;
        }
        return true;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.NEUTRAL, 1, new String[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.NEUTRAL, 2, new String[0]));
        tooltip.add((ITextComponent)LocaleUtil.getLocaleMessage("items.description.boss_summon_item.unstable", TextFormatting.AQUA));
    }
}

