/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.misc.summoning;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoADimensions;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.boss.BaneEntity;
import net.tslat.aoa3.item.misc.summoning.BossSpawningItem;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public class HauntedIdol
extends BossSpawningItem {
    public HauntedIdol() {
        super((Supplier<SoundEvent>)AoASounds.ENTITY_BANE_AMBIENT, new IParticleData[]{ParticleTypes.field_197599_J, ParticleTypes.field_197625_r});
    }

    @Override
    public void spawnBoss(World world, ServerPlayerEntity summoner, double posX, double posY, double posZ) {
        BaneEntity bane = new BaneEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.BANE.get()), world);
        bane.func_70012_b(posX, posY, posZ, RandomUtil.randomValueUpTo(360.0f), 0.0f);
        world.func_217376_c((Entity)bane);
        PlayerUtil.messageAllPlayersInRange((ITextComponent)LocaleUtil.getLocaleMessage("entity.aoa3.bane.spawn", summoner.func_145748_c_().func_150254_d()), world, new BlockPos(posX, posY, posZ), 50);
    }

    @Override
    public boolean canSpawnHere(World world, ServerPlayerEntity player, double posX, double posY, double posZ) {
        if (world.func_201675_m().func_186058_p() != AoADimensions.GRECKON.type()) {
            PlayerUtil.notifyPlayer(player, "entity.aoa3.bane.wrongDimension", TextFormatting.RED);
            return false;
        }
        if (world.func_72829_c(new AxisAlignedBB(posX - 0.5, posY, posZ - 0.5, posX + 0.5, posY + 2.5, posZ + 0.5))) {
            PlayerUtil.notifyPlayer(player, "message.feedback.spawnBoss.noSpace", TextFormatting.RED);
            return false;
        }
        return true;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.NEUTRAL, 1, new String[0]));
        tooltip.add((ITextComponent)LocaleUtil.getLocaleMessage("items.description.boss_summon_item.unstable", TextFormatting.AQUA));
    }
}

