/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.tablet;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.tslat.aoa3.client.gui.adventgui.AdventGuiTabPlayer;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.entity.tablet.SoulTabletEntity;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.constant.Resources;
import net.tslat.aoa3.util.constant.Skills;
import net.tslat.aoa3.util.player.PlayerDataManager;
import net.tslat.aoa3.util.player.PlayerUtil;

public abstract class TabletItem
extends Item {
    private final float initialSoulCost;
    private final float perTickSoulCost;
    private final int animaLevelReq;
    private final int effectRadius;

    public TabletItem(float placementCost, float tickSoulDrain, int levelReq, int effectRadius) {
        super(new Item.Properties().func_200916_a(AoAItemGroups.TABLETS).func_200917_a(1));
        this.initialSoulCost = placementCost;
        this.perTickSoulCost = tickSoulDrain;
        this.animaLevelReq = levelReq;
        this.effectRadius = effectRadius;
    }

    public final float getSoulDrain() {
        return this.perTickSoulCost;
    }

    public int getEffectRadius() {
        return this.effectRadius;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        BlockState targetBlockState = context.func_195991_k().func_180495_p(pos);
        if (context.func_196000_l() != Direction.UP || !targetBlockState.func_224755_d((IBlockReader)world, pos, Direction.UP)) {
            return ActionResultType.FAIL;
        }
        if (context.func_195999_j() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)context.func_195999_j();
            PlayerDataManager plData = PlayerUtil.getAdventPlayer(player);
            if (player.func_184812_l_() || plData.stats().getLevel(Skills.ANIMA) >= this.animaLevelReq) {
                float soulCost = this.initialSoulCost * (1.0f - (float)(plData.stats().getLevel(Skills.ANIMA) - 1) / 200.0f) * (PlayerUtil.isWearingFullSet(player, AdventArmour.Type.ANIMA) ? 0.5f : 1.0f);
                SoulTabletEntity tabletEntity = this.getTabletEntity(world, player);
                VoxelShape blockBoundingBox = targetBlockState.func_196952_d((IBlockReader)world, pos);
                tabletEntity.func_70080_a(context.func_221532_j().func_82615_a(), (double)pos.func_177956_o() + (blockBoundingBox.func_197766_b() ? 0.0 : blockBoundingBox.func_197758_c(Direction.Axis.Y)), context.func_221532_j().func_82616_c(), player.field_70177_z, 0.0f);
                if (world.func_195585_a((Entity)tabletEntity, VoxelShapes.func_197881_a((AxisAlignedBB)tabletEntity.func_174813_aQ())) && plData.stats().consumeResource(Resources.SOUL, soulCost, false)) {
                    world.func_217376_c((Entity)tabletEntity);
                    if (!player.func_184812_l_()) {
                        player.func_184586_b(context.func_221531_n()).func_190918_g(1);
                    }
                    return ActionResultType.SUCCESS;
                }
            } else {
                PlayerUtil.notifyPlayerOfInsufficientLevel(player, Skills.ANIMA, this.animaLevelReq);
            }
        }
        return ActionResultType.PASS;
    }

    protected abstract SoulTabletEntity getTabletEntity(World var1, ServerPlayerEntity var2);

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedLevelRestrictedDescriptionText(Skills.ANIMA, this.animaLevelReq));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.tablet.placementCost", LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, String.valueOf(this.initialSoulCost * (1.0f - (float)(Math.min(100, AdventGuiTabPlayer.getSkillLevel(Skills.ANIMA)) - 1) / 200.0f))));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.tablet.usageCost", LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, String.valueOf((float)((int)(this.perTickSoulCost * 2000.0f)) / 100.0f)));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.tablet.radius", LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, String.valueOf(this.effectRadius)));
    }
}

