/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.tool.misc;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.tslat.aoa3.capabilities.persistentstack.PersistentStackCapabilityHandles;
import net.tslat.aoa3.capabilities.persistentstack.PersistentStackCapabilityProvider;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public class ExpFlask
extends Item {
    public ExpFlask() {
        super(new Item.Properties().func_200916_a(AoAItemGroups.TOOLS).func_200917_a(1));
        this.func_185043_a(new ResourceLocation("filled"), (stack, world, entity) -> {
            PersistentStackCapabilityHandles cap = PersistentStackCapabilityProvider.getOrDefault(stack, null);
            return cap.getValue() <= 0.0f ? 0.0f : 1.0f;
        });
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.DRINK;
    }

    public int func_77626_a(ItemStack stack) {
        return 100;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            PersistentStackCapabilityHandles cap = PersistentStackCapabilityProvider.getOrDefault(stack, null);
            if (cap.getValue() <= 0.0f) {
                return ActionResult.func_226251_d_((Object)stack);
            }
            player.func_184598_c(hand);
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public void onUsingTick(ItemStack stack, LivingEntity entity, int count) {
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            PersistentStackCapabilityHandles cap = PersistentStackCapabilityProvider.getOrDefault(stack, null);
            if (cap.getValue() > 0.0f) {
                int xpChange = (int)Math.min((float)(1 + (int)((float)player.field_71068_ca / 15.0f)), cap.getValue());
                player.func_195068_e(xpChange);
                cap.setValue(cap.getValue() - (float)xpChange);
                if (cap.getValue() == 0.0f) {
                    player.func_184602_cy();
                }
            }
        }
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT tag = super.getShareTag(stack);
        if (tag == null) {
            tag = new CompoundNBT();
        }
        tag.func_74776_a("AdventMiscStackCapability", PersistentStackCapabilityProvider.getOrDefault(stack, null).getValue());
        return tag;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (nbt != null && nbt.func_74764_b("AdventMiscStackCapability")) {
            PersistentStackCapabilityProvider.getOrDefault(stack, null).setValue(nbt.func_74760_g("AdventMiscStackCapability"));
        }
        super.readShareTag(stack, nbt);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new PersistentStackCapabilityProvider(null);
    }

    public static void addExp(ItemStack stack, int xp) {
        PersistentStackCapabilityHandles cap = PersistentStackCapabilityProvider.getOrDefault(stack, null);
        cap.setValue(cap.getValue() + (float)xp);
    }

    public static void setExp(ItemStack stack, int xp) {
        PersistentStackCapabilityProvider.getOrDefault(stack, null).setValue(xp);
    }

    public static boolean consumeExp(ItemStack stack, int xp) {
        PersistentStackCapabilityHandles cap = PersistentStackCapabilityProvider.getOrDefault(stack, null);
        if (cap.getValue() >= (float)xp) {
            cap.setValue(cap.getValue() - (float)xp);
            return true;
        }
        return false;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        int storedValue = (int)PersistentStackCapabilityProvider.getOrDefault(stack, null).getValue();
        if (storedValue > 0) {
            tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.SPECIAL, 1, NumberUtil.floorAndAppendSuffix(storedValue, true) + (storedValue >= 7 ? " (" + PlayerUtil.getPlayerLevelFromExp(storedValue) + ")" : "")));
        }
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.NEUTRAL, 2, new String[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.NEUTRAL, 3, new String[0]));
    }
}

