/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.tool.misc;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootTable;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.misc.pixon.PixonEntity;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.constant.Deities;
import net.tslat.aoa3.util.player.PlayerDataManager;
import net.tslat.aoa3.util.player.PlayerUtil;

public class InfusionBowl
extends Item {
    private final int harvestAmount;
    private final int harvestLevelModifier;

    public InfusionBowl(int durability, int harvestAmount, int harvestLevelModifier) {
        super(new Item.Properties().func_200916_a(AoAItemGroups.TOOLS).func_200918_c(durability));
        this.harvestAmount = harvestAmount;
        this.harvestLevelModifier = harvestLevelModifier;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public int getHarvestAmount() {
        return this.harvestAmount;
    }

    public int getHarvestReqModifier() {
        return this.harvestLevelModifier;
    }

    public boolean func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        if (!(target instanceof PixonEntity)) {
            return false;
        }
        if (player instanceof ServerPlayerEntity) {
            int harvestCount;
            PixonEntity pixon = (PixonEntity)target;
            if (!pixon.canHarvest((ServerPlayerEntity)player, stack)) {
                return false;
            }
            LootTable harvestTable = player.func_184102_h().func_200249_aQ().func_186521_a(pixon.func_213346_cF());
            ArrayList<ItemStack> harvestStacks = new ArrayList<ItemStack>();
            LootContext lootContext = new LootContext.Builder((ServerWorld)player.field_70170_p).func_216015_a(LootParameters.field_216284_d, (Object)player).func_216015_a(LootParameters.field_216281_a, (Object)pixon).func_216015_a(LootParameters.field_216286_f, (Object)pixon.func_180425_c()).func_216015_a(LootParameters.field_216283_c, (Object)DamageSource.field_76377_j).func_216022_a(LootParameterSets.field_216263_d);
            PlayerDataManager plData = PlayerUtil.getAdventPlayer((ServerPlayerEntity)player);
            for (harvestCount = 0; harvestCount < this.getHarvestAmount() && pixon.func_110143_aJ() > 0.0f; ++harvestCount) {
                if (!player.func_184812_l_()) {
                    ItemUtil.damageItem(stack, (LivingEntity)player, 1, hand == Hand.MAIN_HAND ? EquipmentSlotType.MAINHAND : EquipmentSlotType.OFFHAND);
                }
                harvestStacks.addAll(harvestTable.func_216113_a(lootContext));
                if (plData.equipment().getCurrentFullArmourSet() == AdventArmour.Type.INFUSION) {
                    harvestStacks.addAll(harvestTable.func_216113_a(lootContext));
                }
                pixon.func_70606_j(pixon.func_110143_aJ() - 7.0f + (float)RandomUtil.randomNumberUpTo(6));
            }
            if (!harvestStacks.isEmpty()) {
                ItemUtil.givePlayerMultipleItems(player, harvestStacks);
            }
            if (pixon.field_70170_p.func_201675_m().func_186058_p() == DimensionType.field_223227_a_ && pixon.field_70170_p.func_72935_r()) {
                plData.stats().addTribute(Deities.LUXON, 4 * harvestCount);
            }
            if (pixon.func_70089_S()) {
                pixon.func_70604_c((LivingEntity)player);
                pixon.nextHarvestTick = pixon.field_70170_p.func_82737_E() + 8L + (long)pixon.func_70681_au().nextInt(32);
            } else {
                player.func_70074_a((LivingEntity)pixon);
            }
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)stack.func_77973_b()));
            player.field_70170_p.func_184148_a(null, (double)pixon.func_180425_c().func_177958_n(), (double)pixon.func_180425_c().func_177956_o(), (double)pixon.func_180425_c().func_177952_p(), (SoundEvent)AoASounds.ENTITY_PIXON_HARVEST.get(), SoundCategory.MASTER, 1.0f, 1.0f);
        }
        return true;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.infusionBowl.desc.1", LocaleUtil.ItemDescriptionType.NEUTRAL, new String[0]));
    }
}

