/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.tool.pickaxe;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.tslat.aoa3.capabilities.persistentstack.PersistentStackCapabilityHandles;
import net.tslat.aoa3.capabilities.persistentstack.PersistentStackCapabilityProvider;
import net.tslat.aoa3.item.tool.pickaxe.BasePickaxe;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.constant.Resources;
import net.tslat.aoa3.util.player.PlayerDataManager;
import net.tslat.aoa3.util.player.PlayerUtil;

public class EnergisticPickaxe
extends BasePickaxe {
    public EnergisticPickaxe() {
        super(ItemUtil.customItemTier(2000, 11.0f, 6.0f, 6, 10, null));
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        float speed = super.func_150893_a(stack, state);
        if (speed != 1.0f && this.hasEnergy(stack)) {
            return speed * 3.0f;
        }
        return speed;
    }

    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity entity) {
        PersistentStackCapabilityHandles cap = EnergisticPickaxe.getCapability(stack);
        if (super.func_150893_a(stack, state) != 1.0f) {
            cap.setValue(Math.max(0.0f, cap.getValue() - 5.0f));
        }
        return super.func_179218_a(stack, world, state, pos, entity);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (!world.field_72995_K) {
            PersistentStackCapabilityHandles cap = EnergisticPickaxe.getCapability(player.func_184586_b(hand));
            PlayerDataManager plData = PlayerUtil.getAdventPlayer((ServerPlayerEntity)player);
            float storeAmount = MathHelper.func_76131_a((float)(2000.0f - cap.getValue()), (float)0.0f, (float)Math.min(20.0f, plData.stats().getResourceValue(Resources.ENERGY)));
            cap.setValue(cap.getValue() + storeAmount);
            plData.stats().consumeResource(Resources.ENERGY, storeAmount, true);
            return ActionResult.func_226248_a_((Object)player.func_184586_b(hand));
        }
        return super.func_77659_a(world, player, hand);
    }

    private boolean hasEnergy(ItemStack stack) {
        return EnergisticPickaxe.getCapability(stack).getValue() >= 5.0f;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new PersistentStackCapabilityProvider(null);
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT tag = super.getShareTag(stack);
        if (tag == null) {
            tag = new CompoundNBT();
        }
        tag.func_74776_a("AoAEnergyStored", EnergisticPickaxe.getCapability(stack).getValue());
        return tag;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (nbt != null && nbt.func_74764_b("AoAEnergyStored")) {
            EnergisticPickaxe.getCapability(stack).setValue(Math.min(2000.0f, nbt.func_74760_g("AoAEnergyStored")));
        }
        super.readShareTag(stack, nbt);
    }

    public static PersistentStackCapabilityHandles getCapability(ItemStack stack) {
        return PersistentStackCapabilityProvider.getOrDefault(stack, null);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new String[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.tool.energisticCharge", LocaleUtil.ItemDescriptionType.NEUTRAL, new String[0]));
        PersistentStackCapabilityHandles cap = PersistentStackCapabilityProvider.getOrDefault(stack, null);
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.tool.energisticStorage", LocaleUtil.ItemDescriptionType.NEUTRAL, Integer.toString((int)cap.getValue())));
    }
}

