/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.blaster;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.projectile.blaster.AtomizerBounceEntity;
import net.tslat.aoa3.entity.projectile.blaster.AtomizerShotEntity;
import net.tslat.aoa3.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.item.weapon.blaster.BaseBlaster;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;

public class Atomizer
extends BaseBlaster {
    public Atomizer(double dmg, int durability, int fireDelayTicks, float energyCost) {
        super(dmg, durability, fireDelayTicks, energyCost);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_ATOMIZER_FIRE.get();
    }

    @Override
    public void fire(ItemStack blaster, LivingEntity shooter) {
        shooter.field_70170_p.func_217376_c((Entity)new AtomizerShotEntity(shooter, this, 60));
    }

    @Override
    public void doBlockImpact(BaseEnergyShot shot, Vec3d hitPos, LivingEntity shooter) {
        if (shot instanceof AtomizerShotEntity) {
            shot.field_70170_p.func_217376_c((Entity)new AtomizerBounceEntity(shooter, this, (AtomizerShotEntity)shot, field_77697_d.nextGaussian() * 0.5, 1.3, field_77697_d.nextGaussian() * 0.5));
        } else {
            WorldUtil.createExplosion((Entity)shooter, shot.field_70170_p, (Entity)shot, 1.5f);
        }
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        if (super.doEntityImpact(shot, target, shooter)) {
            WorldUtil.createExplosion((Entity)shooter, shot.field_70170_p, (Entity)shot, 1.5f);
            if (shot instanceof AtomizerShotEntity) {
                shot.field_70170_p.func_217376_c((Entity)new AtomizerBounceEntity(shooter, this, (AtomizerShotEntity)shot, field_77697_d.nextGaussian() * 0.5, 1.3, field_77697_d.nextGaussian() * 0.5));
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new String[0]));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

