/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.blaster;

import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.tslat.aoa3.common.registration.AoAEnchantments;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.item.EnergyProjectileWeapon;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.constant.Resources;
import net.tslat.aoa3.util.player.PlayerDataManager;
import net.tslat.aoa3.util.player.PlayerUtil;

public abstract class BaseBlaster
extends Item
implements EnergyProjectileWeapon {
    protected final double baseDmg;
    protected final int firingDelay;
    protected final float energyCost;

    public BaseBlaster(Item.Properties properties, double dmg, int fireDelayTicks, float energyCost) {
        super(properties);
        this.baseDmg = dmg;
        this.firingDelay = fireDelayTicks;
        this.energyCost = energyCost;
    }

    public BaseBlaster(double dmg, int durability, int fireDelayTicks, float energyCost) {
        this(new Item.Properties().func_200916_a(AoAItemGroups.BLASTERS).func_200918_c(durability), dmg, fireDelayTicks, energyCost);
    }

    public double getDamage() {
        return this.baseDmg;
    }

    public int getFiringDelay() {
        return this.firingDelay;
    }

    public float getEnergyCost() {
        return this.energyCost;
    }

    @Nullable
    public SoundEvent getFiringSound() {
        return null;
    }

    public boolean func_82789_a(ItemStack stack, ItemStack repairMaterial) {
        return false;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.NONE;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (hand != this.getWeaponHand((LivingEntity)player)) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        if (player.func_184825_o(0.0f) < 1.0f) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        if (player instanceof ServerPlayerEntity) {
            PlayerDataManager plData = PlayerUtil.getAdventPlayer((ServerPlayerEntity)player);
            int recharge = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)AoAEnchantments.RECHARGE.get()), (ItemStack)stack);
            int greed = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)AoAEnchantments.GREED.get()), (ItemStack)stack);
            float energyConsumption = (1.0f + 0.3f * (float)greed) * this.energyCost * Math.max(0.0f, 1.0f - 0.07f * (float)recharge);
            if (plData.equipment().getCurrentFullArmourSet() == AdventArmour.Type.GHOULISH) {
                energyConsumption *= 0.7f;
            }
            if (plData.stats().getResourceValue(Resources.ENERGY) < energyConsumption) {
                return ActionResult.func_226251_d_((Object)stack);
            }
            player.func_184598_c(hand);
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (player instanceof ServerPlayerEntity) {
            float energyConsumption;
            PlayerDataManager plData = PlayerUtil.getAdventPlayer((ServerPlayerEntity)player);
            int recharge = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)AoAEnchantments.RECHARGE.get()), (ItemStack)stack);
            int greed = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)AoAEnchantments.GREED.get()), (ItemStack)stack);
            float f = energyConsumption = ((PlayerEntity)player).func_184812_l_() ? 0.0f : (1.0f + 0.3f * (float)greed) * this.energyCost * Math.max(0.0f, 1.0f - 0.07f * (float)recharge);
            if (plData.equipment().getCurrentFullArmourSet() == AdventArmour.Type.GHOULISH) {
                energyConsumption *= 0.7f;
            }
            if (plData.stats().getResourceValue(Resources.ENERGY) >= energyConsumption) {
                if (count + this.firingDelay <= 72000 && count % this.firingDelay == 0) {
                    if (this.consumeEnergy(plData, stack, energyConsumption)) {
                        if (this.getFiringSound() != null) {
                            player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), this.getFiringSound(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                        }
                        this.fire(stack, player);
                        ((PlayerEntity)player).func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                        if ((72000 - count) / this.firingDelay >= this.getMaxDamage(stack) - stack.func_77952_i()) {
                            ItemUtil.damageItem(stack, player, (72000 - count) / this.firingDelay, EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)AoAEnchantments.BRACE.get()), (ItemStack)stack) > 0 ? EquipmentSlotType.OFFHAND : EquipmentSlotType.MAINHAND);
                        }
                    } else {
                        player.func_184597_cx();
                    }
                }
            } else {
                if (player.func_184607_cu() != ItemStack.field_190927_a) {
                    PlayerUtil.notifyPlayerOfInsufficientResources((ServerPlayerEntity)player, Resources.ENERGY, energyConsumption);
                }
                player.func_184597_cx();
            }
        }
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity player, int useTicksRemaining) {
        ItemUtil.damageItem(stack, player, (72000 - useTicksRemaining - 1) / this.firingDelay, EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)AoAEnchantments.BRACE.get()), (ItemStack)stack) > 0 ? EquipmentSlotType.OFFHAND : EquipmentSlotType.MAINHAND);
    }

    public abstract void fire(ItemStack var1, LivingEntity var2);

    public boolean consumeEnergy(PlayerDataManager plData, ItemStack stack, float cost) {
        return plData.stats().consumeResource(Resources.ENERGY, cost, false);
    }

    @Override
    public Hand getWeaponHand(LivingEntity holder) {
        return Hand.MAIN_HAND;
    }

    @Override
    public void doBlockImpact(BaseEnergyShot shot, Vec3d hitPos, LivingEntity shooter) {
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        if (DamageUtil.dealBlasterDamage(shooter, target, (Entity)shot, (float)this.baseDmg, false)) {
            this.doImpactEffect(shot, target, shooter);
            return true;
        }
        return false;
    }

    protected void doImpactEffect(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (this.baseDmg > 0.0) {
            tooltip.add(1, (ITextComponent)LocaleUtil.getLocaleMessage("items.description.damage.blaster", TextFormatting.DARK_RED, NumberUtil.roundToNthDecimalPlace((float)this.baseDmg, 1)));
        }
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.blaster.fire", LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new String[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.blaster.slowing", LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new String[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.blaster.effect", LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new String[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.gun.firingSpeed", LocaleUtil.ItemDescriptionType.NEUTRAL, Double.toString((double)(2000 / this.firingDelay) / 100.0)));
        float energyConsumption = (1.0f + 0.3f * (float)EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)AoAEnchantments.GREED.get()), (ItemStack)stack)) * this.getEnergyCost() * Math.max(0.0f, 1.0f - 0.07f * (float)EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)AoAEnchantments.RECHARGE.get()), (ItemStack)stack));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.ammo.resource", LocaleUtil.ItemDescriptionType.ITEM_AMMO_COST, NumberUtil.roundToNthDecimalPlace(energyConsumption, 2), LocaleUtil.getLocaleString("resources.energy.name")));
    }

    public int func_77619_b() {
        return 8;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        CompoundNBT tag = stack.func_196082_o();
        tag.func_74774_a("HideFlags", (byte)2);
        return null;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", this.firingDelay < 20 ? -3.4666666984558105 : (double)-3.6f, AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }
}

